package ext.data {
import ext.Base;

[Deprecated(replacement="ext.data.field.DataField", since="5.0")]
[Native]
/**
 * <p>Type of singleton Types.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html Original Ext JS documentation of 'Ext.data.Types'
 * @see ext.data.#Types ext.data.Types
 */
public class STypes extends Base {
  /**
   * This data type means that no conversion is applied to the raw data before it is placed
   * into a Record.
   * @default {
   *     sortType: SortTypes.none,
   *     type: 'auto'
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-AUTO Original Ext JS documentation of 'AUTO'
   */
  public native function get AUTO():Object;

  /**
   * This data type means that the raw data is converted into a boolean before it is placed
   * into a Record. The string "true" and the number 1 are converted to boolean true.
   * <p>The synonym <code>→BOOLEAN</code> is equivalent.</p>
   * @default {
   *     convert: function(v) {
   *         if (typeof v === 'boolean') {
   *             return v;
   *         }
   *         if (this.getAllowNull() && (v === undefined || v === null || v === '')) {
   *             return null;
   *         }
   *         return v === 'true' || v == 1;
   *     },
   *     // eslint-disable-line eqeqeq
   *     sortType: SortTypes.none,
   *     type: 'bool'
   * }
   * @see STypes#BOOLEAN
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-BOOL Original Ext JS documentation of 'BOOL'
   */
  public native function get BOOL():Object;

  /**
   * This data type means that the raw data is converted into a boolean before it is placed into
   * a Record. The string "true" and the number 1 are converted to boolean <code>true</code>.
   * <p>The synonym <code>→BOOL</code> is equivalent.</p>
   * @default Types.BOOL
   * @see STypes#BOOL
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-BOOLEAN Original Ext JS documentation of 'BOOLEAN'
   */
  public native function get BOOLEAN():Object;

  /**
   * This data type means that the raw data is converted into a Date before it is placed
   * into a Record. The date format is specified in the constructor of the
   * →<code>ext.data.field.DataField</code> to which this type is being applied.
   * @default {
   *     convert: function(v) {
   *         var df = this.getDateReadFormat() || this.getDateFormat(),
   *             parsed;
   *         if (!v) {
   *             return null;
   *         }
   *         // instanceof check ~10 times faster than Ext.isDate. Values here will not
   *         // be cross-document objects
   *         if (v instanceof Date) {
   *             return v;
   *         }
   *         if (df) {
   *             return Ext.Date.parse(v, df);
   *         }
   *         parsed = Date.parse(v);
   *         return parsed ? new Date(parsed) : null;
   *     },
   *     sortType: SortTypes.asDate,
   *     type: 'date'
   * }
   * @see ext.data.field.DataField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-DATE Original Ext JS documentation of 'DATE'
   */
  public native function get DATE():Object;

  /**
   * This data type means that the raw data is converted into a number before it is placed
   * into a Record.
   * <p>The synonym <code>→NUMBER</code> is equivalent.</p>
   * @default {
   *     convert: function(v) {
   *         if (typeof v === 'number') {
   *             return v;
   *         }
   *         return v !== undefined && v !== null && v !== '' ? parseFloat(String(v).replace(Types.stripRe, ''), 10) : (this.getAllowNull() ? null : 0);
   *     },
   *     sortType: SortTypes.none,
   *     type: 'float'
   * }
   * @see STypes#NUMBER
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-FLOAT Original Ext JS documentation of 'FLOAT'
   */
  public native function get FLOAT():Object;

  /**
   * This data type means that the raw data is converted into an integer before it is placed
   * into a Record.
   * <p>The synonym <code>→INTEGER</code> is equivalent.</p>
   * @default {
   *     convert: function(v) {
   *         // Handle values which are already numbers.
   *         // Value truncation behaviour of parseInt is historic and must be maintained.
   *         // parseInt(35.9)  and parseInt("35.9") returns 35
   *         if (typeof v === 'number') {
   *             return parseInt(v, 10);
   *         }
   *         return v !== undefined && v !== null && v !== '' ? parseInt(String(v).replace(Types.stripRe, ''), 10) : (this.getAllowNull() ? null : 0);
   *     },
   *     sortType: SortTypes.none,
   *     type: 'int'
   * }
   * @see STypes#INTEGER
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-INT Original Ext JS documentation of 'INT'
   */
  public native function get INT():Object;

  /**
   * This data type means that the raw data is converted into an integer before it is placed
   * into a Record.
   * <p>The synonym <code>→INT</code> is equivalent.</p>
   * @default Types.INT
   * @see STypes#INT
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-INTEGER Original Ext JS documentation of 'INTEGER'
   */
  public native function get INTEGER():Object;

  /**
   * This data type means that the raw data is converted into a number before it is placed
   * into a Record.
   * <p>The synonym <code>→FLOAT</code> is equivalent.</p>
   * @default Types.FLOAT
   * @see STypes#FLOAT
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-NUMBER Original Ext JS documentation of 'NUMBER'
   */
  public native function get NUMBER():Object;

  /**
   * This data type means that the raw data is converted into a String before it is placed
   * into a Record.
   * @default {
   *     convert: function(v) {
   *         var defaultValue = this.getAllowNull() ? null : '';
   *         return (v === undefined || v === null) ? defaultValue : String(v);
   *     },
   *     sortType: SortTypes.asUCString,
   *     type: 'string'
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-STRING Original Ext JS documentation of 'STRING'
   */
  public native function get STRING():Object;

  /**
   * A regular expression for stripping non-numeric characters from a numeric value.
   * This should be overridden for localization.
   * @default /[$,%]/g
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Types.html#property-stripRe Original Ext JS documentation of 'stripRe'
   */
  public native function get stripRe():RegExp;

  /**
   * @private
   */
  public native function set stripRe(value:RegExp):void;
}
}