package ext.data {
import ext.ExtClass;
import ext.mixin.IDirty;
import ext.mixin.Observable;

[Native("Ext.data.Session", require)]
/**
 * @see ext.data.events.Session_dirtyEvent.DIRTY_CHANGE
 * @eventType ext.data.events.Session_dirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.data.events.Session_dirtyEvent')]
/**
 * This class manages models and their associations. Instances of <code>Session</code> are typically
 * associated with some <code>Component</code> (perhaps the Viewport or a Window) and then used by
 * their <code>view models (→ext.app.ViewModel)</code> to enable data binding.
 * <p>The primary job of a Session is to manage a collection of records of many different
 * types and their associations. This often starts by loading records when requested (via
 * bind - see below) and culminates when it is time to save to the server.</p>
 * <p>Because the Session tracks all records it loads, it ensures that for any given type of
 * model, only one record exists with a given <code>id</code>. This means that all edits of that
 * record are properly targeted at that one instance.</p>
 * <p>Similarly, when associations are loaded, the <code>→ext.data.Store</code> created to hold the
 * associated records is tracked by the Session. So all requests for the "OrderItems" of
 * a particular Order id will result in the same Store. Adding and removing items from
 * that Order then is sure to remain consistent.</p>
 * <p><b>Data</b></p>
 * <p>Since the Session is managing all this data, there are several methods it provides
 * to give convenient access to that data. The most important of these is <code>→update()</code> and
 * <code>→getChanges()</code>.</p>
 * <p>The <code>→update()</code> and <code>→getChanges()</code> methods both operate on object that contains a summary
 * of records and associations and different CRUD operations.</p>
 * <p><b><i>Saving</i></b></p>
 * <p>There are two basic ways to save the contents of a Session: <code>→getChanges()</code> and
 * <code>→getSaveBatch()</code>. We've already seen <code>→getChanges()</code>. The data contained in the CRUD object
 * can be translated into whatever shape is needed by the server.</p>
 * <p>To leverage the <code>→ext.data.Model.proxy</code> facilities defined by each Model
 * class, there is the <code>→getSaveBatch()</code> method. That method returns an <code>→ext.data.Batch</code>
 * object populated with the necessary <code>→create()</code>, <code>→update()</code> and <code>→destroy()</code> operations to
 * save all of the changes in the Session.</p>
 * <p><b><i>Conflicts</i></b></p>
 * <p>If data is loaded from the server (for example a store load) and there is an existing record,
 * the <i><code>mergeData</code></i> (→<code>ext.data.Model.mergeData()</code>) method will be called to resolve
 * the conflict.</p>
 * @see ext.app.ViewModel
 * @see ext.data.Store
 * @see #update()
 * @see #getChanges()
 * @see #getSaveBatch()
 * @see ext.data.Model#proxy
 * @see ext.data.Batch
 * @see #create()
 * @see #destroy()
 * @see ext.data.Model#mergeData()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html Original Ext JS documentation of 'Ext.data.Session'
 */
public class Session extends Observable implements IDirty {
  /**
   * @param config @inheritDoc
   */
  public function Session(config:Session = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to automatically destroy this session when a component it is attached
   * to is destroyed. This should be set to false if the session is intended to be
   * used across multiple root level components.
   * @default true
   * @since 5.0.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#cfg-autoDestroy Original Ext JS documentation of 'autoDestroy'
   * @see #getAutoDestroy()
   * @see #setAutoDestroy()
   */
  public native function get autoDestroy():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set autoDestroy(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This config property describes the modified state of this object. In most
   * cases this config's value is maintained by the object and should be considered
   * readonly. The class implementor should be the only one to call the setter.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-dirty Original Ext JS documentation of 'dirty'
   * @see #getDirty()
   * @see #setDirty()
   */
  public native function get dirty():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dirty(value:Boolean):void;

  [ExtConfig]
  /**
   * This config property indicates that the <code>→dirty</code> state of this object should be
   * ignored. Because this capability is mixed in at a class level, this config can
   * be helpful when some instances do not participate in dirty state tracking.
   * <p>This option should be set at construction time. When set to <code>true</code>, the object
   * will always have <code>→dirty</code> value of <code>false</code>.</p>
   * @default false
   * @see #dirty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-ignoreDirty Original Ext JS documentation of 'ignoreDirty'
   */
  public native function get ignoreDirty():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ignoreDirty(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The parent session for this session.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#cfg-parent Original Ext JS documentation of 'parent'
   * @see #getParent()
   * @see #setParent()
   */
  public native function get parent():Session;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set parent(value:Session):void;

  [ExtConfig]
  /**
   * Set this config at construction time (or on the class body) to automatically set
   * the <code>→dirty</code> state based on the records passed to <code>→trackRecordState()</code>.
   * <p>This config defaults to <code>true</code> but only has an effect when the record tracking
   * methods are called (<code>→trackRecordState()</code>, <code>→untrackRecordState()</code> and <code>→clearRecordStates()</code>).</p>
   * @default true
   * @see #dirty
   * @see #trackRecordState()
   * @see #untrackRecordState()
   * @see #clearRecordStates()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-recordStateIsDirtyState Original Ext JS documentation of 'recordStateIsDirtyState'
   */
  public native function get recordStateIsDirtyState():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set recordStateIsDirtyState(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#cfg-schema Original Ext JS documentation of 'schema'
   * @see #getSchema()
   * @see #setSchema()
   */
  public native function get schema():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set schema(value:*):void;

  /**
   * Adds an existing record instance to the session. The record
   * may not belong to another session. The record cannot be a phantom record, instead
   * use →<code>createRecord()</code>.
   * @param record The record to adopt.
   * @see #createRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-adopt Original Ext JS documentation of 'adopt'
   */
  public native function adopt(record:Model):void;

  /**
   * Template method, will be called by Model after a record is committed.
   * @since 6.2.0
   * @param record The record.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-afterCommit Original Ext JS documentation of 'afterCommit'
   */
  protected native function afterCommit(record:Model):void;

  /**
   * Template method, will be called by Model after a record is dropped.
   * @since 6.2.0
   * @param record The record.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-afterDrop Original Ext JS documentation of 'afterDrop'
   */
  protected native function afterDrop(record:Model):void;

  /**
   * Template method, will be called by Model after a record is edited.
   * @since 6.2.0
   * @param record The record.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-afterEdit Original Ext JS documentation of 'afterEdit'
   */
  protected native function afterEdit(record:Model):void;

  /**
   * Template method, will be called by Model after a record is erased (a drop
   * that is committed).
   * @param record The record.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-afterErase Original Ext JS documentation of 'afterErase'
   */
  protected native function afterErase(record:Model):void;

  /**
   * Template method, will be called by Model after a record is rejected.
   * @since 6.5.1
   * @param record The record.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-afterReject Original Ext JS documentation of 'afterReject'
   */
  protected native function afterReject(record:Model):void;

  /**
   * Clears all record state tracking. This state is maintained by <code>→trackRecordState()</code>
   * and <code>→untrackRecordState()</code>.
   * @see #trackRecordState()
   * @see #untrackRecordState()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-clearRecordStates Original Ext JS documentation of 'clearRecordStates'
   */
  protected native function clearRecordStates():void;

  /**
   * Marks the session as "clean" by calling →<code>ext.data.Model.commit()</code> on each record
   * that is known to the session.
   * <ul>
   * <li>Phantom records will no longer be phantom.</li>
   * <li>Modified records will no longer be dirty.</li>
   * <li>Dropped records will be erased.</li>
   * </ul>
   * @since 5.1.0
   * @see ext.data.Model#commit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-commit Original Ext JS documentation of 'commit'
   */
  public native function commit():void;

  /**
   * Creates a new record and tracks it in this session.
   * @param type The <code>entityName</code> or the actual class of record to create.
   * @param data The data for the record.
   * @return The new record.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-createRecord Original Ext JS documentation of 'createRecord'
   */
  public native function createRecord(type:*, data:Object = null):Model;

  /**
   * Returns the value of <code>autoDestroy</code>.
   * @see #autoDestroy
   */
  public native function getAutoDestroy():Boolean;

  /**
   * Returns an object describing all of the modified fields, created or dropped records
   * and many-to-many association changes maintained by this session.
   * @return An object in the CRUD format (see the intro docs). <code>null</code> if there are
   * no changes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-getChanges Original Ext JS documentation of 'getChanges'
   */
  public native function getChanges():Object;

  /**
   * The same functionality as →<code>getChanges()</code>, however we also take into account our
   * parent session.
   * @return An object in the CRUD format (see the intro docs). <code>null</code> if there are
   * no changes.
   * @see #getChanges()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-getChangesForParent Original Ext JS documentation of 'getChangesForParent'
   */
  protected native function getChangesForParent():Object;

  /**
   * Returns the value of <code>dirty</code>.
   * @see #dirty
   */
  public native function getDirty():Boolean;

  /**
   * Returns the value of <code>parent</code>.
   * @see #parent
   */
  public native function getParent():Session;

  /**
   * Get a cached record from the session. If the record does not exist, it will
   * be created. If the <code>autoLoad</code> parameter is not set to <code>false</code>, the record will
   * be loaded via the →<code>ext.data.Model.proxy</code> of the Model.
   * <p>If this session is configured with a <code>→parent</code> session, a <i>copy</i> of any existing
   * record in the <code>→parent</code> will be adopted into this session. If the <code>→parent</code> does not contain
   * the record, the record will be created and <i>not</i> inserted into the parent.</p>
   * <p>See also →<code>peekRecord()</code>.</p>
   * @param type The <code>entityName</code> or the actual class of record
   * to create. This may also be a record instance, where the type and id will be inferred from
   * the record. If the record is not attached to a session, it will be adopted. If it exists
   * in a parent, an appropriate copy will be made as described.
   * @param id The id of the record.
   * @param autoLoad <code>false</code> to prevent the record from being loaded if
   * it does not exist. If this parameter is an object, it will be passed to the
   * →<code>ext.data.Model.load()</code> call.
   * @default true
   * @return The record.
   * @see ext.data.Model#proxy
   * @see #parent
   * @see #peekRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-getRecord Original Ext JS documentation of 'getRecord'
   * @see ext.data.Model#load()
   */
  public native function getRecord(type:*, id:Object, autoLoad:* = true):Model;

  /**
   * Returns an <code>→ext.data.Batch</code> containing the <code>→ext.data.operation.Operation</code> instances
   * that are needed to save all of the changes in this session. This sorting is based
   * on operation type, associations and foreign keys. Generally speaking the operations
   * in the batch can be committed to a server sequentially and the server will never be
   * sent a request with an invalid (client-generated) id in a foreign key field.
   * @param sort Pass <code>false</code> to disable the batch operation sort.
   * @default true
   * @see ext.data.Batch
   * @see ext.data.operation.Operation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-getSaveBatch Original Ext JS documentation of 'getSaveBatch'
   */
  public native function getSaveBatch(sort:Boolean = true):Batch;

  /**
   * Returns the value of <code>schema</code>.
   * @see #schema
   */
  public native function getSchema():*;

  /**
   * @inheritDoc
   */
  public native function isDirty():void;

  /**
   * Triggered when an associated item from →<code>update()</code> references a record
   * that does not exist in the session.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param entityType The entity type.
   * @param id The id of the model.
   * @see #update()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-onInvalidAssociationEntity Original Ext JS documentation of 'onInvalidAssociationEntity'
   */
  protected native function onInvalidAssociationEntity(entityType:ExtClass, id:Object):void;

  /**
   * Triggered when an drop block from →<code>update()</code> tries to create a record
   * that already exists.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param entityType The entity type.
   * @param id The id of the model.
   * @see #update()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-onInvalidEntityCreate Original Ext JS documentation of 'onInvalidEntityCreate'
   */
  protected native function onInvalidEntityCreate(entityType:ExtClass, id:Object):void;

  /**
   * Triggered when an drop block from →<code>update()</code> references a record
   * that does not exist in the session.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param entityType The entity type.
   * @param id The id of the model.
   * @see #update()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-onInvalidEntityDrop Original Ext JS documentation of 'onInvalidEntityDrop'
   */
  protected native function onInvalidEntityDrop(entityType:ExtClass, id:Object):void;

  /**
   * Triggered when an drop block from →<code>update()</code> tries to create a record
   * that already exists.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param entityType The entity type.
   * @param id The id of the model.
   * @see #update()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-onInvalidEntityRead Original Ext JS documentation of 'onInvalidEntityRead'
   */
  protected native function onInvalidEntityRead(entityType:ExtClass, id:Object):void;

  /**
   * Triggered when an update block from →<code>update()</code> references a record
   * that does not exist in the session.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param entityType The entity type.
   * @param id The id of the model.
   * @param dropped <code>true</code> if the record was dropped.
   * @see #update()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-onInvalidEntityUpdate Original Ext JS documentation of 'onInvalidEntityUpdate'
   */
  protected native function onInvalidEntityUpdate(entityType:ExtClass, id:Object, dropped:Boolean):void;

  /**
   * Gets an existing record from the session. The record will <i>not</i> be created if it does
   * not exist.
   * <p>See also: →<code>getRecord()</code>.</p>
   * @param type The <code>entityName</code> or the actual class of record to create.
   * @param id The id of the record.
   * @param deep <code>true</code> to consult
   * @default false
   * @return The record, <code>null</code> if it does not exist.
   * @see #getRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-peekRecord Original Ext JS documentation of 'peekRecord'
   */
  public native function peekRecord(type:*, id:Object, deep:Boolean = false):Model;

  /**
   * Save any changes in this session to a →<code>parent</code> session.
   * @see #parent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-save Original Ext JS documentation of 'save'
   */
  public native function save():void;

  /**
   * Sets the value of <code>autoDestroy</code>.
   * @param autoDestroy The new value.
   * @see #autoDestroy
   */
  public native function setAutoDestroy(autoDestroy:Boolean):void;

  /**
   * Sets the value of <code>dirty</code>.
   * @param dirty The new value.
   * @see #dirty
   */
  public native function setDirty(dirty:Boolean):void;

  /**
   * Sets the value of <code>parent</code>.
   * @param parent The new value.
   * @see #parent
   */
  public native function setParent(parent:Session):void;

  /**
   * Sets the value of <code>schema</code>.
   * @param schema The new value.
   * @see #schema
   */
  public native function setSchema(schema:*):void;

  /**
   * Create a child session with this session as the →<code>parent</code>.
   * @return The copied session.
   * @see #parent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-spawn Original Ext JS documentation of 'spawn'
   */
  public native function spawn():Session;

  /**
   * This method is called to track a given record in the total number of dirty records
   * (modified, created or dropped). See <code>→untrackRecordState()</code> and <code>→clearRecordStates()</code>.
   * @param record The record to track.
   * @param initial Pass <code>true</code> the first time a record is introduced.
   * @return Returns <code>true</code> if the state of dirty records has changed.
   * @see #untrackRecordState()
   * @see #clearRecordStates()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-trackRecordState Original Ext JS documentation of 'trackRecordState'
   */
  protected native function trackRecordState(record:Model, initial:Boolean):Boolean;

  /**
   * This method is called to remove the tracking of a given record from the total number
   * of dirty records (modified, created or dropped). The record passed to this method
   * must have been previously passed to <code>→trackRecordState()</code>.
   * @param record The record to stop tracking.
   * @return Returns <code>true</code> if the state of dirty records has changed.
   * @see #trackRecordState()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-untrackRecordState Original Ext JS documentation of 'untrackRecordState'
   */
  protected native function untrackRecordState(record:Model):Boolean;

  /**
   * Complete a bulk update for this session.
   * @param data Data in the CRUD format (see the intro docs).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Session.html#method-update Original Ext JS documentation of 'update'
   */
  public native function update(data:Object):void;
}
}