package ext.data {

[Native("Ext.data.SortTypes", require)]
/**
 * This class defines a series of static methods that are used on a
 * →<code>ext.data.field.DataField</code> for performing sorting. The methods cast the
 * underlying values into a data type that is appropriate for sorting on
 * that particular field. If a →<code>ext.data.field.DataField.type</code> is specified,
 * the sortType will be set to a sane default if the sortType is not
 * explicitly defined on the field. The sortType will make any necessary
 * modifications to the value and return it.
 * <ul>
 * <li><b><code>→asText()</code></b> - Removes any tags and converts the value to a string</li>
 * <li><b><code>→asUCText()</code></b> - Removes any tags and converts the value to an uppercase string</li>
 * <li><b><code>→asUCString()</code></b> - Converts the value to an uppercase string</li>
 * <li><b><code>→asDate()</code></b> - Converts the value into Unix epoch time</li>
 * <li><b><code>→asFloat()</code></b> - Converts the value to a floating point number</li>
 * <li><b><code>→asInt()</code></b> - Converts the value to an integer number</li>
 * </ul>
 * <p>It is also possible to create a custom sortType that can be used throughout
 * an application.</p>
 * <pre>
 *  Ext.apply(Ext.data.SortTypes, {
 *      asPerson: function(person){
 *          // expects an object with a first and last name property
 *          return person.lastName.toUpperCase() + person.firstName.toLowerCase();
 *      }
 *  });
 *
 *  Ext.define('Employee', {
 *      extend: 'Ext.data.Model',
 *      fields: [{
 *          name: 'person',
 *          sortType: 'asPerson'
 *      }, {
 *          name: 'salary',
 *          type: 'float' // sortType set to asFloat
 *      }]
 *  });
 * </pre>
 * @see ext.data.field.DataField
 * @see ext.data.field.DataField#type
 * @see SSortTypes#asText()
 * @see SSortTypes#asUCText()
 * @see SSortTypes#asUCString()
 * @see SSortTypes#asDate()
 * @see SSortTypes#asFloat()
 * @see SSortTypes#asInt()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html Original Ext JS documentation of 'Ext.data.SortTypes'
 */
public const SortTypes:SSortTypes = new SSortTypes;
}