package ext.data {

[Native("Ext.data.StoreManager", require)]
/**
 * Contains a collection of all stores that are created that have an identifier. An identifier
 * can be assigned by setting the →<code>ext.data.AbstractStore.storeId</code> property. When
 * a store is in the StoreManager, it can be referred to via it's identifier:
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     model: 'SomeModel',
 *     storeId: 'myStore'
 * });
 *
 * var store = Ext.data.StoreManager.lookup('myStore');
 * </pre>
 * <p>Also note that the →<code>lookup()</code> method is aliased to →<code>ext.Ext.getStore()</code> for convenience.</p>
 * <p>If a store is registered with the StoreManager, you can also refer to the store by its
 * identifier when registering it with any Component that consumes data from a store:</p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     model: 'SomeModel',
 *     storeId: 'myStore'
 * });
 *
 * Ext.create('Ext.view.View', {
 *     store: 'myStore',
 *     // other configuration here
 * });
 * </pre>
 * @see ext.data.AbstractStore#storeId
 * @see SStoreManager#lookup()
 * @see ext.SExt#getStore() ext.Ext.getStore()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.StoreManager.html Original Ext JS documentation of 'Ext.data.StoreManager'
 */
public const StoreManager:SStoreManager = new SStoreManager;
}