package ext.data {
import ext.Component;
import ext.data.operation.DestroyOperation;
import ext.mixin.IQueryable;
import ext.tree.TreePanel;

[Native("Ext.data.TreeModel", require)]
/**
 * This class is used as a base class from which to derive Models used in Trees.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeModel.html Original Ext JS documentation of 'Ext.data.TreeModel'
 */
public class TreeModel extends Model implements IQueryable, NodeInterface {
  /**
   * @param config @inheritDoc
   */
  public function TreeModel(data:Object, session:Session = null) {
    super(null);
  }

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get allowDrag():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowDrag(value:Boolean):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get allowDrop():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowDrop(value:Boolean):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get checked():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checked(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get childNodes():Array;

  /**
   * @private
   */
  public native function set childNodes(value:Array):void;

  [ExtConfig]
  /**
   * The class name of child nodes to create when reading child nodes from
   * raw data. By default the type configured into the TreeStore is used.
   * <p>This is one way of creating heterogeneous nodes in a tree.</p>
   * <p>To do this through data types passed from the server, use the
   * →<code>ext.data.reader.DataReader.typeProperty</code>.</p>
   * <p>for example in the case of a hidden root node, you'd use the default type at level zero.
   * See →<code>ext.tree.TreePanel</code>'s documentation for an example.</p>
   * <p><i>Important</i>
   * If you are using this declaration on your tree models, and have a
   * <i>hidden root node</i> (→<code>ext.tree.TreePanel.rootVisible</code>), you MUST create a special root model
   * definition which declares the type of its children.</p>
   * <p>If you allow the TreeStore to create a root node of the same type as the first level of
   * <i>visible</i> nodes then the reader will atempt to read the wrong type of child node for the
   * root.</p>
   * <p>Example:</p>
   * <pre>
   * Ext.define('myApp.World', {
   *     childType: 'Territory'
   * });
   *
   * ...
   *
   * store: {
   *     id: 'myTreeStore',
   *     model: 'myApp.World' // The hidden root will know to create 'Territory' type children
   * }
   * </pre>
   * <p>If the root is hidden, and the first level of visible nodes are going to be the
   * <code>myApp.Territory</code> class, then the hidden root must not be of the <code>myApp.Territory</code> class.
   * Otherwise, it would try to read in the territory data as its childType - most likely
   * 'Country'.</p>
   * @see ext.data.reader.DataReader#typeProperty
   * @see ext.tree.TreePanel
   * @see ext.tree.TreePanel#rootVisible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeModel.html#cfg-childType Original Ext JS documentation of 'childType'
   */
  public native function get childType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set childType(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get children():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set children(value:Array):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get cls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cls(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get expandable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandable(value:Boolean):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get expanded():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expanded(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get firstChild():NodeInterface;

  /**
   * @private
   */
  public native function set firstChild(value:NodeInterface):void;

  /**
   * @inheritDoc
   */
  public native function get glyph():String;

  /**
   * @private
   */
  public native function set glyph(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get href():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set href(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get hrefTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hrefTarget(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get icon():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set icon(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get iconCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get isNode():Boolean;

  /**
   * @private
   */
  public native function set isNode(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get lastChild():NodeInterface;

  /**
   * @private
   */
  public native function set lastChild(value:NodeInterface):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get leaf():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set leaf(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get nextSibling():NodeInterface;

  /**
   * @private
   */
  public native function set nextSibling(value:NodeInterface):void;

  /**
   * @inheritDoc
   */
  public native function get parentNode():NodeInterface;

  /**
   * @private
   */
  public native function set parentNode(value:NodeInterface):void;

  /**
   * @inheritDoc
   */
  public native function get previousSibling():NodeInterface;

  /**
   * @private
   */
  public native function set previousSibling(value:NodeInterface):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get qshowDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set qshowDelay(value:Number):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get qtip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set qtip(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get qtitle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set qtitle(value:String):void;

  [ExtConfig]
  /**
   * @inheritDoc
   */
  public native function get text():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set text(value:String):void;

  /**
   * @inheritDoc
   */
  public native function appendChild(node:*, suppressEvents:Boolean = false, commit:Boolean = false):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function bubble(fn:Function, scope:Object = null, args:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function cascade(spec:*, scope:Object = null, args:Array = null, after:Function = null):void;

  /**
   * @inheritDoc
   */
  public native function child(selector:* = undefined):Component;

  /**
   * @inheritDoc
   */
  public native function collapse(recursive:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function collapseChildren(recursive:Function = null, callback:Function = null, scope:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function contains(node:NodeInterface):Boolean;

  /**
   * @inheritDoc
   */
  public native function copyNode(id:String = null, session:Object = null, deep:Boolean = false):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function createNode(node:Object):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function down(selector:* = undefined):Component;

  /**
   * @inheritDoc
   */
  public native function eachChild(fn:Function, scope:Object = null, args:Array = null):void;

  /**
   * @inheritDoc
   */
  override public native function erase(options:Object = null):DestroyOperation;

  /**
   * @inheritDoc
   */
  public native function expand(recursive:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function expandChildren(recursive:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function findChild(attribute:String, value:Object, deep:Boolean = false):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function findChildBy(fn:Function, scope:Object = null, deep:Boolean = false):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function fireEvent(eventName:String, ...args):Boolean;

  /**
   * @inheritDoc
   */
  public native function getChildAt(index:Number):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function getDepth():Number;

  /**
   * @inheritDoc
   */
  public native function getOwnerTree():TreePanel;

  /**
   * @inheritDoc
   */
  public native function getPath(field:String = null, separator:String = '/'):String;

  /**
   * @inheritDoc
   */
  public native function getTreeStore():TreeStore;

  /**
   * @inheritDoc
   */
  public native function hasChildNodes():Boolean;

  /**
   * @inheritDoc
   */
  public native function indexOf(node:NodeInterface):Number;

  /**
   * @inheritDoc
   */
  public native function indexOfId(id:String):Number;

  /**
   * @inheritDoc
   */
  public native function insertBefore(node:*, refNode:NodeInterface):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function insertChild(index:Number, node:*):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function isAncestor(node:NodeInterface):Boolean;

  /**
   * @inheritDoc
   */
  public native function isBranchLoaded():Boolean;

  /**
   * @inheritDoc
   */
  public native function isExpandable():Boolean;

  /**
   * @inheritDoc
   */
  public native function isExpanded():Boolean;

  /**
   * @inheritDoc
   */
  public native function isFirst():Boolean;

  /**
   * @inheritDoc
   */
  public native function isLast():Boolean;

  /**
   * @inheritDoc
   */
  public native function isLeaf():Boolean;

  /**
   * @inheritDoc
   */
  public native function isLoaded():Boolean;

  /**
   * @inheritDoc
   */
  override public native function isLoading():Boolean;

  /**
   * @inheritDoc
   */
  public native function isRoot():Boolean;

  /**
   * @inheritDoc
   */
  public native function isVisible():Boolean;

  /**
   * @inheritDoc
   */
  public native function onRegisterTreeNode(treeStore:TreeStore):void;

  /**
   * @inheritDoc
   */
  public native function onUnregisterTreeNode(treeStore:TreeStore):void;

  /**
   * @inheritDoc
   */
  public native function query(selector:String = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryBy(fn:Function, scope:Object = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryById(id:String):Component;

  /**
   * @inheritDoc
   */
  public native function remove(erase:Boolean = false):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function removeAll(erase:Boolean = false):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function removeChild(node:NodeInterface, erase:Boolean = false):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function replaceChild(newChild:NodeInterface, oldChild:NodeInterface):NodeInterface;

  /**
   * @inheritDoc
   */
  public native function serialize(writerParam:Object):void;

  /**
   * @inheritDoc
   */
  public native function sort(sortFn:Function = null, recursive:Boolean = false, suppressEvent:Boolean = false):void;

  [ArrayElementType("String")]
  /**
   * @inheritDoc
   */
  public native function updateInfo(commit:Boolean, info:Object):Array;

  /**
   * @inheritDoc
   */
  public native function visitPostOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function visitPreOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;
}
}