package ext.data {
import ext.util.MixedCollection;

[Native("Ext.data.TreeStore", require)]
/**
 * @see ext.data.events.TreeStore_records_successful_operation_nodeEvent.LOAD
 * @eventType ext.data.events.TreeStore_records_successful_operation_nodeEvent.LOAD
 */
[Event(name='onLoad', type='ext.data.events.TreeStore_records_successful_operation_nodeEvent')]
/**
 * @see ext.data.events.TreeStore_node_indexEvent.NODE_APPEND
 * @eventType ext.data.events.TreeStore_node_indexEvent.NODE_APPEND
 */
[Event(name='onNodeAppend', type='ext.data.events.TreeStore_node_indexEvent')]
/**
 * @see ext.data.events.TreeStore_nodeEvent.NODE_BEFORE_APPEND
 * @eventType ext.data.events.TreeStore_nodeEvent.NODE_BEFORE_APPEND
 */
[Event(name='onNodeBeforeAppend', type='ext.data.events.TreeStore_nodeEvent')]
/**
 * @see ext.data.events.TreeStoreEvent.NODE_BEFORE_COLLAPSE
 * @eventType ext.data.events.TreeStoreEvent.NODE_BEFORE_COLLAPSE
 */
[Event(name='onNodeBeforeCollapse', type='ext.data.events.TreeStoreEvent')]
/**
 * @see ext.data.events.TreeStoreEvent.NODE_BEFORE_EXPAND
 * @eventType ext.data.events.TreeStoreEvent.NODE_BEFORE_EXPAND
 */
[Event(name='onNodeBeforeExpand', type='ext.data.events.TreeStoreEvent')]
/**
 * @see ext.data.events.TreeStore_node_refNodeEvent.NODE_BEFORE_INSERT
 * @eventType ext.data.events.TreeStore_node_refNodeEvent.NODE_BEFORE_INSERT
 */
[Event(name='onNodeBeforeInsert', type='ext.data.events.TreeStore_node_refNodeEvent')]
/**
 * @see ext.data.events.TreeStore_oldParent_newParent_indexEvent.NODE_BEFORE_MOVE
 * @eventType ext.data.events.TreeStore_oldParent_newParent_indexEvent.NODE_BEFORE_MOVE
 */
[Event(name='onNodeBeforeMove', type='ext.data.events.TreeStore_oldParent_newParent_indexEvent')]
/**
 * @see ext.data.events.TreeStore_node_isMoveEvent.NODE_BEFORE_REMOVE
 * @eventType ext.data.events.TreeStore_node_isMoveEvent.NODE_BEFORE_REMOVE
 */
[Event(name='onNodeBeforeRemove', type='ext.data.events.TreeStore_node_isMoveEvent')]
/**
 * @see ext.data.events.TreeStoreEvent.NODE_COLLAPSE
 * @eventType ext.data.events.TreeStoreEvent.NODE_COLLAPSE
 */
[Event(name='onNodeCollapse', type='ext.data.events.TreeStoreEvent')]
/**
 * @see ext.data.events.TreeStoreEvent.NODE_EXPAND
 * @eventType ext.data.events.TreeStoreEvent.NODE_EXPAND
 */
[Event(name='onNodeExpand', type='ext.data.events.TreeStoreEvent')]
/**
 * @see ext.data.events.TreeStore_node_refNodeEvent.NODE_INSERT
 * @eventType ext.data.events.TreeStore_node_refNodeEvent.NODE_INSERT
 */
[Event(name='onNodeInsert', type='ext.data.events.TreeStore_node_refNodeEvent')]
/**
 * @see ext.data.events.TreeStore_oldParent_newParent_indexEvent.NODE_MOVE
 * @eventType ext.data.events.TreeStore_oldParent_newParent_indexEvent.NODE_MOVE
 */
[Event(name='onNodeMove', type='ext.data.events.TreeStore_oldParent_newParent_indexEvent')]
/**
 * @see ext.data.events.TreeStore_node_isMove_contextEvent.NODE_REMOVE
 * @eventType ext.data.events.TreeStore_node_isMove_contextEvent.NODE_REMOVE
 */
[Event(name='onNodeRemove', type='ext.data.events.TreeStore_node_isMove_contextEvent')]
/**
 * @see ext.data.events.TreeStore_childNodesEvent.NODE_SORT
 * @eventType ext.data.events.TreeStore_childNodesEvent.NODE_SORT
 */
[Event(name='onNodeSort', type='ext.data.events.TreeStore_childNodesEvent')]
/**
 * @see ext.data.events.TreeStore_newRoot_oldRootEvent.ROOT_CHANGE
 * @eventType ext.data.events.TreeStore_newRoot_oldRootEvent.ROOT_CHANGE
 */
[Event(name='onRootChange', type='ext.data.events.TreeStore_newRoot_oldRootEvent')]
/**
 * The TreeStore is a store implementation that owns the <i>root node</i> (→<code>root</code>) of
 * a tree, and provides methods to load either local or remote data as child nodes of the root
 * and any descendant non-leaf node.
 * <p>The TreeStore must be used as the store of a <i>tree panel</i> (→<code>ext.tree.TreePanel</code>).</p>
 * <p>This class also relays many node events from the underlying node structure.</p>
 * <p><b>Using Models</b></p>
 * <p>If no Model is specified, an implicit model will be created that extends
 * →<code>ext.data.TreeModel</code>. The standard Tree fields will also be copied onto the Model
 * for maintaining their state. These fields are listed in the →<code>ext.data.NodeInterface</code>
 * documentation.</p>
 * <p><b>Reading Nested Data</b></p>
 * <p>For the tree to read nested data, the →<code>ext.data.reader.DataReader</code> must be configured
 * with a root property, so the reader can find nested data for each node (if a root is not
 * specified, it will default to 'children'). This will tell the tree to look for any nested tree
 * nodes by the same keyword, i.e., 'children'. If a root is specified in the config make sure
 * that any nested nodes with children have the same name.</p>
 * <p><b>Note:</b> Setting →<code>defaultRootProperty</code> accomplishes the same thing.</p>
 * <p><b>rootProperty as a Function</b></p>
 * <p>You can pass a function as the data reader's rootProperty when the tree's dataset has
 * mixed root properties. Child nodes can then be programmatically determined at read time.</p>
 * <p>For example, the child nodes may be passed via the 'children' property
 * name, though you may have a top-level root property of 'items'.</p>
 * <p>See →<code>ext.data.reader.DataReader.rootProperty</code> for more information.</p>
 * <p><b>Filtering</b></p>
 * <p>Filtering of nodes in a TreeStore is hierarchically top down by default. This means that
 * if a non-leaf node does not pass the filter, then it, and all its descendants are filtered <i>out</i>
 * of the store.</p>
 * <p>To reverse this, so that any node which passes the filter causes all its ancestors to be visible,
 * configure the <code>TreeStore</code> with '<i>filterer: 'bottomup'</i> (→<code>filterer</code>)`</p>
 * <p>You may also programmatically filter individual tree nodes by setting their <code>'visible'</code> field.</p>
 * <p>Setting this to <code>false</code> filters the node out so that it will not appear in the UI. Setting it
 * to <code>true</code> filters the node in.</p>
 * <p>Note that if performing several filter operations, it is best to →<code>suspendEvents()</code>
 * on the store first, and when all nodes have been modified, →<code>resumeEvents()</code> and fire
 * the →<code>event:onRefresh</code> event on the store.</p>
 * @see #root
 * @see ext.tree.TreePanel
 * @see ext.data.TreeModel
 * @see ext.data.NodeInterface
 * @see ext.data.reader.DataReader
 * @see #defaultRootProperty
 * @see ext.data.reader.DataReader#rootProperty
 * @see #filterer
 * @see #suspendEvents()
 * @see #resumeEvents()
 * @see #event:onRefresh
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html Original Ext JS documentation of 'Ext.data.TreeStore'
 */
public class TreeStore extends Store {
  /**
   * @param config @inheritDoc
   */
  public function TreeStore(config:TreeStore = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Remove previously existing child nodes before loading.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-clearOnLoad Original Ext JS documentation of 'clearOnLoad'
   * @see #getClearOnLoad()
   * @see #setClearOnLoad()
   */
  public native function get clearOnLoad():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set clearOnLoad(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, when a node is reloaded, any records in the →<code>removed</code> record
   * collection that were previously descendants of the node being reloaded will be
   * cleared from the →<code>removed</code> collection. Only applicable if
   * →<code>clearOnLoad</code> is <code>true</code>.
   * @default true
   * @see #removed
   * @see #clearOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-clearRemovedOnLoad Original Ext JS documentation of 'clearRemovedOnLoad'
   * @see #getClearRemovedOnLoad()
   * @see #setClearRemovedOnLoad()
   */
  override public native function get clearRemovedOnLoad():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set clearRemovedOnLoad(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default root id.
   * @default 'root'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-defaultRootId Original Ext JS documentation of 'defaultRootId'
   * @see #getDefaultRootId()
   * @see #setDefaultRootId()
   */
  public native function get defaultRootId():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultRootId(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default 'children'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-defaultRootProperty Original Ext JS documentation of 'defaultRootProperty'
   * @see #getDefaultRootProperty()
   * @see #setDefaultRootProperty()
   */
  public native function get defaultRootProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultRootProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default root text (if not specified)
   * @default 'Root'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-defaultRootText Original Ext JS documentation of 'defaultRootText'
   * @see #getDefaultRootText()
   * @see #setDefaultRootText()
   */
  public native function get defaultRootText():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultRootText(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * An Array of <code>→ext.data.field.DataField</code> config objects, simply the field
   * →<code>ext.data.field.DataField.name</code>, or a mix of config objects and strings.
   * If just a name is given, the field type defaults to <code>auto</code>.
   * <p>In a →<code>ext.data.field.DataField</code> config object you may pass the alias of
   * the <code>Ext.data.field.&#42;</code> type using the <code>type</code> config option.</p>
   * <pre>
   * // two fields are set:
   * // - an 'auto' field with a name of 'firstName'
   * // - and an Ext.data.field.Integer field with a name of 'age'
   * fields: ['firstName', {
   *     type: 'int',
   *     name: 'age'
   * }]
   * </pre>
   * <p>Fields will automatically be created at read time for any for any keys in the
   * data passed to the Model's <i>proxy's</i> (→<code>proxy</code>)
   * <i>reader</i> (→<code>ext.data.reader.DataReader</code>) whose name is not explicitly configured in
   * the <code>→fields</code> config.</p>
   * <p>Extending a Model class will inherit all the <code>→fields</code> from the superclass /
   * ancestor classes.
   * <b>Note:</b> If you wish to create a Tree<i>Grid</i>, and configure your tree
   * with a →<code>ext.panel.TablePanel.columns</code> configuration, it is possible
   * to define the set of fields you wish to use in the Store instead of configuring
   * the store with a →<code>model</code>.</p>
   * <p>By default, the Store uses an →<code>ext.data.TreeModel</code>. If you configure
   * fields, it uses a subclass of →<code>ext.data.TreeModel</code> defined with the set of
   * fields that you specify (in addition to the fields which it uses for storing
   * internal state).</p>
   * @see ext.data.field.DataField
   * @see ext.data.field.DataField#name
   * @see #proxy
   * @see ext.data.reader.DataReader
   * @see #fields
   * @see ext.panel.TablePanel#columns
   * @see #model
   * @see ext.data.TreeModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-fields Original Ext JS documentation of 'fields'
   * @see #getFields()
   * @see #setFields()
   */
  override public native function get fields():MixedCollection;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set fields(value:*):void;

  [ExtConfig]
  /**
   * The order in which to prioritize how filters are applied to nodes.
   * <p>The default, <code>'topdown'</code> means that if a parent node does <i>not</i> pass the filter,
   * then the branch ends there, and no descendant nodes are filtered in, even if they
   * would pass the filter.</p>
   * <p>By specifying <code>'bottomup'</code>, if a leaf node passes the filter, then all its
   * ancestor nodes are filtered in to allow it to be visible.</p>
   * @default 'topdown'
   * @since 6.0.2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-filterer Original Ext JS documentation of 'filterer'
   */
  public native function get filterer():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set filterer(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Set to true to automatically prepend a leaf sorter.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-folderSort Original Ext JS documentation of 'folderSort'
   * @see #getFolderSort()
   * @see #setFolderSort()
   */
  public native function get folderSort():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set folderSort(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-groupDir Original Ext JS documentation of 'groupDir'
   * @see #getGroupDir()
   * @see #setGroupDir()
   */
  override public native function get groupDir():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set groupDir(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-groupField Original Ext JS documentation of 'groupField'
   * @see #getGroupField()
   * @see #setGroupField()
   */
  override public native function get groupField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set groupField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-grouper Original Ext JS documentation of 'grouper'
   * @see #getGrouper()
   * @see #setGrouper()
   */
  override public native function get grouper():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set grouper(value:*):void;

  /**
   * The class name of the model that this store uses if no explicit →<code>model</code> is
   * given
   * @default 'Ext.data.TreeModel'
   * @see #model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#property-implicitModel Original Ext JS documentation of 'implicitModel'
   */
  public native function get implicitModel():Boolean;

  /**
   * @private
   */
  public native function set implicitModel(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated TreeStore, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#property-isTreeStore Original Ext JS documentation of 'isTreeStore'
   */
  public native function get isTreeStore():Boolean;

  /**
   * @private
   */
  public native function set isTreeStore(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to true to prevent child nodes from being loaded until the the node is
   * expanded or loaded explicitly.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-lazyFill Original Ext JS documentation of 'lazyFill'
   */
  public native function get lazyFill():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lazyFill(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the parameter sent to the server which contains the identifier of
   * the node.
   * @default 'node'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-nodeParam Original Ext JS documentation of 'nodeParam'
   * @see #getNodeParam()
   * @see #setNodeParam()
   */
  public native function get nodeParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set nodeParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-pageSize Original Ext JS documentation of 'pageSize'
   * @see #getPageSize()
   * @see #setPageSize()
   */
  override public native function get pageSize():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set pageSize(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * This config allows node data to be returned from the server in linear format
   * without having to structure it into <code>children</code> arrays.
   * <p>This property specifies which property name in the raw node data yields the id
   * of the parent node.</p>
   * <p>For example the following data would be read into a geographic tree by
   * configuring the TreeStore with <code>parentIdProperty: 'parentId'</code>. The node data
   * contains an upward link to a parent node.</p>
   * <pre>
   * data: [{
   *     name: 'North America',
   *     id: 'NA'
   * }, {
   *     name: 'Unites States',
   *     id: 'USA',
   *     parentId: 'NA'
   * }, {
   *     name: 'Redwood City',
   *     leaf: true,
   *     parentId: 'USA'
   * }, {
   *     name: 'Frederick, MD',
   *     leaf: true,
   *     parentId: 'USA'
   * }]
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-parentIdProperty Original Ext JS documentation of 'parentIdProperty'
   * @see #getParentIdProperty()
   * @see #setParentIdProperty()
   */
  public native function get parentIdProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set parentIdProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The root node for this store. For example:
   * <pre>
   * root: {
   *     expanded: true,
   *     text: "My Root",
   *     children: [
   *         { text: "Child 1", leaf: true },
   *         { text: "Child 2", expanded: true, children: [
   *             { text: "GrandChild", leaf: true }
   *         ] }
   *     ]
   * }
   * </pre>
   * <p>Setting the <code>→root</code> config option is the same as calling →<code>setRootNode()</code>.</p>
   * <p>It's important to note that setting expanded to true on the root node will
   * cause the tree store to attempt to load. This will occur regardless the value
   * of →<code>ext.data.ProxyStore.autoLoad</code>. If you you do not want the
   * store to load on instantiation, ensure expanded is false and load the store
   * when you're ready.</p>
   * @default null
   * @see #root
   * @see #setRootNode()
   * @see ext.data.ProxyStore#autoLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-root Original Ext JS documentation of 'root'
   * @see #getRoot()
   * @see #setRoot()
   */
  public native function get root():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set root(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>false</code> to not include the root node in this Stores collection.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#cfg-rootVisible Original Ext JS documentation of 'rootVisible'
   * @see #getRootVisible()
   * @see #setRootVisible()
   */
  public native function get rootVisible():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rootVisible(value:Boolean):void;

  /**
   * Collects unique values for a particular dataIndex from this store.
   * @param property The property to collect
   * @param includeOptions An object which contains options which modify how
   * the store is traversed. For compatibility, this argument may be the <code>allowNull</code>
   * value itself. If so, the next argument is the <code>filtered</code> value.
   * <ul>
   * <li><code>allowNull:Boolean</code> (optional) —
   * Pass true to allow null, undefined or
   * empty string values.
   * </li>
   * <li><code>filtered:Boolean</code> (optional) —
   * Pass <code>true</code> to collect from all records,
   * even ones which are filtered.
   * </li>
   * </ul>
   * @param filtered This argument only applies when the legacy call form
   * is used and <code>includeOptions</code> is actually the <code>allowNull</code> value.
   * @return An array of the unique values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-collect Original Ext JS documentation of 'collect'
   */
  override public native function collect(property:String, includeOptions:Object = null, filtered:Boolean = false):Array;

  /**
   * Calls the specified function for each <i>node</i> (→<code>ext.data.NodeInterface</code>) in the store.
   * <p>When store is filtered, only loops over the filtered records unless the <code>bypassFilters</code>
   * parameter is <code>true</code>.</p>
   * @param fn The function to call. The <i>Record</i> (→<code>ext.data.Model</code>) is passed
   * as the first parameter. Returning <code>false</code> aborts and exits the iteration.
   * @param scope The scope (<code>this</code> reference) in which the function is executed.
   * Defaults to the current <i>node</i> (→<code>ext.data.NodeInterface</code>) in the iteration.
   * @param includeOptions An object which contains options which
   * modify how the store is traversed. Alternatively, this parameter can be just the
   * <code>filtered</code> option.
   * <ul>
   * <li><code>filtered:Boolean</code> (optional) —
   * Pass <code>true</code> to include filtered out
   * nodes in the iteration.
   * </li>
   * <li><code>collapsed:Boolean</code> (optional) —
   * Pass <code>true</code> to include nodes which are
   * descendants of collapsed nodes.
   * </li>
   * </ul>
   * @see ext.data.NodeInterface
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-each Original Ext JS documentation of 'each'
   * @see ext.data.Model
   */
  override public native function each(fn:Function, scope:Object = null, includeOptions:* = undefined):void;

  /**
   * Finds the first matching node in the tree by a specific field value regardless of visibility
   * due to collapsed states; all nodes present in the tree structure are searched.
   * @param fieldName The name of the Record field to test.
   * @param value Either a string that the field value
   * should begin with, or a RegExp to test against the field.
   * @param startsWith Pass <code>false</code> to allow a match to start
   * anywhere in the string. By default the <code>value</code> will match only at the start
   * of the string.
   * @default true
   * @param endsWith Pass <code>false</code> to allow the match to end before
   * the end of the string. By default the <code>value</code> will match only at the end of the
   * string.
   * @default true
   * @param ignoreCase Pass <code>false</code> to make the <code>→RegExp</code> case
   * sensitive (removes the 'i' flag).
   * @default true
   * @return The matched node or null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-findNode Original Ext JS documentation of 'findNode'
   * @see RegExp
   */
  public native function findNode(fieldName:String, value:*, startsWith:Boolean = true, endsWith:Boolean = true, ignoreCase:Boolean = true):NodeInterface;

  /**
   * Called when the event handler which called the →<code>load()</code> method exits.
   * @see #load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-flushLoad Original Ext JS documentation of 'flushLoad'
   */
  override public native function flushLoad():void;

  /**
   * A mixin that provides common store methods for Ext.data.Store &amp; Ext.data.ChainedStore.
   * <b>NOTE:</b> TreeStore's getById method will only search nodes that
   * are expanded (all ancestor nodes are →<code>ext.data.NodeInterface.expanded</code>: true -- →<code>ext.data.NodeInterface.isExpanded()</code>)
   * <p>See also →<code>getNodeById()</code></p>
   * @param id The id of the Record to find.
   * @see ext.data.NodeInterface#expanded
   * @see ext.data.NodeInterface#isExpanded()
   * @see #getNodeById()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-getById Original Ext JS documentation of 'getById'
   */
  override public native function getById(id:*):Model;

  /**
   * Returns the value of <code>clearOnLoad</code>.
   * @see #clearOnLoad
   */
  public native function getClearOnLoad():Boolean;

  /**
   * Returns the value of <code>clearRemovedOnLoad</code>.
   * @see #clearRemovedOnLoad
   */
  override public native function getClearRemovedOnLoad():Boolean;

  /**
   * Returns the value of <code>defaultRootId</code>.
   * @see #defaultRootId
   */
  public native function getDefaultRootId():String;

  /**
   * Returns the value of <code>defaultRootProperty</code>.
   * @see #defaultRootProperty
   */
  public native function getDefaultRootProperty():String;

  /**
   * Returns the value of <code>defaultRootText</code>.
   * @see #defaultRootText
   */
  public native function getDefaultRootText():String;

  /**
   * Returns the value of <code>fields</code>.
   * @see #fields
   */
  override public native function getFields():*;

  /**
   * Returns the value of <code>folderSort</code>.
   * @see #folderSort
   */
  public native function getFolderSort():Boolean;

  /**
   * Returns the value of <code>groupDir</code>.
   * @see #groupDir
   */
  override public native function getGroupDir():String;

  /**
   * Returns the value of <code>groupField</code>.
   * @see #groupField
   */
  override public native function getGroupField():String;

  /**
   * Returns the value of <code>grouper</code>.
   * @see #grouper
   */
  override public native function getGrouper():*;

  /**
   * Returns the record node by id regardless of visibility due to collapsed states;
   * all nodes present in the tree structure are available.
   * @param id The id of the node to get.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-getNodeById Original Ext JS documentation of 'getNodeById'
   */
  public native function getNodeById(id:String):NodeInterface;

  /**
   * Returns the value of <code>nodeParam</code>.
   * @see #nodeParam
   */
  public native function getNodeParam():String;

  /**
   * Returns the value of <code>pageSize</code>.
   * @see #pageSize
   */
  override public native function getPageSize():Number;

  /**
   * Returns the value of <code>parentIdProperty</code>.
   * @see #parentIdProperty
   */
  public native function getParentIdProperty():String;

  /**
   * Returns the value of <code>root</code>.
   * @see #root
   */
  public native function getRoot():*;

  [Deprecated(replacement="getRoot", since="5.0")]
  /**
   * Returns the root node for this tree.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-getRootNode Original Ext JS documentation of 'getRootNode'
   */
  public native function getRootNode():NodeInterface;

  /**
   * Returns the value of <code>rootVisible</code>.
   * @see #rootVisible
   */
  public native function getRootVisible():Boolean;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-isVisible Original Ext JS documentation of 'isVisible'
   */
  public native function isVisible(node:Object):Boolean;

  /**
   * Marks this store as needing a load. When the current executing event handler exits,
   * this store will send a request to load using its configured →<code>proxy</code>.
   * <p><b>Be aware that it is not usually valid for a developer to call this method on a TreeStore.</b></p>
   * <p>TreeStore loads are triggered by a load request from an existing
   * <i>tree node</i> (→<code>ext.data.NodeInterface</code>), when the node is expanding, and it has no
   * locally defined children in its data.</p>
   * <p><i>Note:</i> Even for synchronous Proxy types such as <i>memory proxy</i> (→<code>ext.data.proxy.MemoryProxy</code>),
   * the result will <i>NOT</i> be available in the following line of code. You must use a callback
   * in the load options, or a <i>load listener</i> (→<code>event:onLoad</code>).</p>
   * @param options This is passed into the
   * →<code>ext.data.operation.Operation</code> object that is created and then sent to the
   * proxy's →<code>ext.data.proxy.DataProxy.read()</code> function. In addition to the options listed below,
   * this object may contain properties to configure the
   * →<code>ext.data.operation.Operation</code>.
   * <ul>
   * <li><code>callback:Function</code> (optional) —
   * A function which is called when the response arrives.
   * <ul>
   * <li><code>records:Array</code> (optional) —
   * Array of records.
   * </li>
   * <li><code>operation:ext.data.operation.Operation</code> (optional) —
   * The Operation itself.
   * </li>
   * <li><code>success:Boolean</code> (optional) —
   * <code>true</code> when operation completed successfully.
   * </li>
   * </ul>
   * </li>
   * <li><code>addRecords:Boolean</code> (default = <code>false</code>) —
   * Specify as <code>true</code> to <i>add</i> the incoming records
   * rather than the default which is to have the incoming records <i>replace</i> the existing store
   * contents.
   * </li>
   * </ul>
   * @see #proxy
   * @see ext.data.NodeInterface
   * @see ext.data.proxy.MemoryProxy
   * @see #event:onLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-load Original Ext JS documentation of 'load'
   * @see ext.data.operation.Operation
   * @see ext.data.proxy.DataProxy#read()
   */
  override public native function load(options:Object = null):Store;

  /**
   * Reloads the root node of this store.
   * @param options A config object which contains options which may override the
   * options passed to the previous load call. See the
   * →<code>load()</code> method for valid configs.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-reload Original Ext JS documentation of 'reload'
   * @see #load()
   */
  override public native function reload(options:Object = null):void;

  /**
   * Sets the value of <code>clearOnLoad</code>.
   * @param clearOnLoad The new value.
   * @see #clearOnLoad
   */
  public native function setClearOnLoad(clearOnLoad:Boolean):void;

  /**
   * Sets the value of <code>clearRemovedOnLoad</code>.
   * @param clearRemovedOnLoad The new value.
   * @see #clearRemovedOnLoad
   */
  override public native function setClearRemovedOnLoad(clearRemovedOnLoad:Boolean):void;

  /**
   * Sets the value of <code>defaultRootId</code>.
   * @param defaultRootId The new value.
   * @see #defaultRootId
   */
  public native function setDefaultRootId(defaultRootId:String):void;

  /**
   * Sets the value of <code>defaultRootProperty</code>.
   * @param defaultRootProperty The new value.
   * @see #defaultRootProperty
   */
  public native function setDefaultRootProperty(defaultRootProperty:String):void;

  /**
   * Sets the value of <code>defaultRootText</code>.
   * @param defaultRootText The new value.
   * @see #defaultRootText
   */
  public native function setDefaultRootText(defaultRootText:String):void;

  /**
   * Sets the value of <code>fields</code>.
   * @param fields The new value.
   * @see #fields
   */
  override public native function setFields(fields:*):void;

  /**
   * Sets the value of <code>folderSort</code>.
   * @param folderSort The new value.
   * @see #folderSort
   */
  public native function setFolderSort(folderSort:Boolean):void;

  /**
   * Sets the value of <code>groupDir</code>.
   * @param groupDir The new value.
   * @see #groupDir
   */
  override public native function setGroupDir(groupDir:String):void;

  /**
   * Sets the value of <code>groupField</code>.
   * @param groupField The new value.
   * @see #groupField
   */
  override public native function setGroupField(groupField:String):void;

  /**
   * Sets the value of <code>grouper</code>.
   * @param grouper The new value.
   * @see #grouper
   */
  override public native function setGrouper(grouper:*):void;

  /**
   * Sets the value of <code>nodeParam</code>.
   * @param nodeParam The new value.
   * @see #nodeParam
   */
  public native function setNodeParam(nodeParam:String):void;

  /**
   * Sets the value of <code>pageSize</code>.
   * @param pageSize The new value.
   * @see #pageSize
   */
  override public native function setPageSize(pageSize:Number):void;

  /**
   * Sets the value of <code>parentIdProperty</code>.
   * @param parentIdProperty The new value.
   * @see #parentIdProperty
   */
  public native function setParentIdProperty(parentIdProperty:String):void;

  /**
   * Sets the value of <code>root</code>.
   * @param root The new value.
   * @see #root
   */
  public native function setRoot(root:*):void;

  [Deprecated(replacement="setRoot", since="5.0")]
  /**
   * Sets the root node for this store. See also the →<code>root</code> config option.
   * @return The new root
   * @see #root
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#method-setRootNode Original Ext JS documentation of 'setRootNode'
   */
  public native function setRootNode(root:*):NodeInterface;

  /**
   * Sets the value of <code>rootVisible</code>.
   * @param rootVisible The new value.
   * @see #rootVisible
   */
  public native function setRootVisible(rootVisible:Boolean):void;
}
}