package ext.data {

[Native("Ext.data.Validation", require)]
/**
 * This class is used to hold validation errors for a record. The results of the record's
 * <code>→ext.data.Model.validators</code> are stored as the field values of this
 * record. The first failed validation is all that is stored per field unless the Model
 * class has defined a <code>→validationSeparator</code> config.
 * @see ext.data.Model#validators
 * @see #validationSeparator
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Validation.html Original Ext JS documentation of 'Ext.data.Validation'
 */
public class Validation extends Model {
  /**
   * @inheritDoc
   */
  public function Validation(config:Model = null) {
    super(config);
  }

  /**
   * The associated record for this validation instance.
   * @default record
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Validation.html#property-record Original Ext JS documentation of 'record'
   */
  public native function get record():Model;

  /**
   * Returns true if the associated record (not this one) is valid.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Validation.html#method-isValid Original Ext JS documentation of 'isValid'
   */
  override public native function isValid():Boolean;
}
}