package ext.data {

[Native("Ext.data.XmlStore", require)]
/**
 * Small helper class to make creating →<code>ext.data.Store</code>s from XML data easier.
 * An XmlStore will be automatically configured with a →<code>ext.data.reader.XmlReader</code>.
 * <p>A store configuration would be something like:</p>
 * <pre>
 * var store = new Ext.data.XmlStore({
 *     // store configs
 *     storeId: 'myStore',
 *     url: 'sheldon.xml', // automatically configures a HttpProxy
 *
 *     // reader configs
 *     record: 'Item', // records will have an "Item" tag
 *     idPath: 'ASIN',
 *     totalRecords: '&#64;TotalResults'
 *
 *     fields: [
 *         // set up the fields mapping into the xml doc
 *         // The first needs mapping, the others are very basic
 *         {name: 'Author', mapping: 'ItemAttributes &gt; Author'},
 *         'Title', 'Manufacturer', 'ProductGroup'
 *     ]
 * });
 * </pre>
 * <p>This store is configured to consume a returned object of the form:</p>
 * <pre>
 *  &lt;?xml version="1.0" encoding="UTF-8"?&gt;
 *  &lt;ItemSearchResponse xmlns="http://webservices.amazon.com/AWSECommerceService/2009-05-15"&gt;
 *      &lt;Items&gt;
 *          &lt;Request&gt;
 *              &lt;IsValid&gt;True&lt;/IsValid&gt;
 *              &lt;ItemSearchRequest&gt;
 *                  &lt;Author&gt;Sidney Sheldon&lt;/Author&gt;
 *                  &lt;SearchIndex&gt;Books&lt;/SearchIndex&gt;
 *              &lt;/ItemSearchRequest&gt;
 *          &lt;/Request&gt;
 *          &lt;TotalResults&gt;203&lt;/TotalResults&gt;
 *          &lt;TotalPages&gt;21&lt;/TotalPages&gt;
 *          &lt;Item&gt;
 *              &lt;ASIN&gt;0446355453&lt;/ASIN&gt;
 *              &lt;DetailPageURL&gt;
 *                  http://www.amazon.com/
 *              &lt;/DetailPageURL&gt;
 *              &lt;ItemAttributes&gt;
 *                  &lt;Author&gt;Sidney Sheldon&lt;/Author&gt;
 *                  &lt;Manufacturer&gt;Warner Books&lt;/Manufacturer&gt;
 *                  &lt;ProductGroup&gt;Book&lt;/ProductGroup&gt;
 *                  &lt;Title&gt;Master of the Game&lt;/Title&gt;
 *              &lt;/ItemAttributes&gt;
 *          &lt;/Item&gt;
 *      &lt;/Items&gt;
 *  &lt;/ItemSearchResponse&gt;
 * </pre>
 * <p>An object literal of this form could also be used as the →<code>data</code> config option.
 * <b>Note:</b> This class accepts all of the configuration options of
 * →<code>ext.data.reader.XmlReader</code>.</p>
 * @see ext.data.Store
 * @see ext.data.reader.XmlReader
 * @see #data
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.XmlStore.html Original Ext JS documentation of 'Ext.data.XmlStore'
 */
public class XmlStore extends Store {
  /**
   * @param config @inheritDoc
   */
  public function XmlStore(config:XmlStore = null) {
    super();
  }
}
}