package ext.data.events {
import ext.data.Store;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.AbstractStore_storeEvent")]
public class AbstractStore_storeEvent extends FlExtEvent {
  /**
   * Fires after a store is sorted.
   * <p>For <i>remotely sorted</i> (→<code>remoteSort</code>) stores, this will be upon the success of a load
   * operation triggered by changing the store's sorters.</p>
   * <p>For locally sorted stores, this will be just after the data items in the store's backing
   * collection are sorted.</p>
   * @see ext.data.AbstractStore#remoteSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#event-sort Original Ext JS documentation of 'sort'
   * @see ext.data.AbstractStore
   * @eventType onSort
   */
  public static const SORT:String = "onSort";
  public static const __PARAMETER_SEQUENCE__:Array = ["store", "eOpts"];

  public function AbstractStore_storeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The store being sorted
   */
  public native function get store():Store;
}
}