package ext.data.events {
import ext.data.Store;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.AbstractStore_store_records_indexEvent")]
public class AbstractStore_store_records_indexEvent extends FlExtEvent {
  /**
   * Fired when a Model instance has been added to this Store.
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#event-add Original Ext JS documentation of 'add'
   * @see ext.data.AbstractStore
   * @eventType onAdd
   */
  public static const ADD:String = "onAdd";
  public static const __PARAMETER_SEQUENCE__:Array = ["store", "records", "index", "eOpts"];

  public function AbstractStore_store_records_indexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index at which the records were inserted.
   */
  public native function get index():Number;

  [ArrayElementType("ext.data.Model")]
  /**
   * The records that were added.
   */
  public native function get records():Array;

  /**
   * The store.
   */
  public native function get store():Store;
}
}