package ext.data.events {
import ext.data.Store;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.AbstractStore_store_sortersEvent")]
public class AbstractStore_store_sortersEvent extends FlExtEvent {
  /**
   * Fires before a store is sorted.
   * <p>For <i>remotely sorted</i> (→<code>remoteSort</code>) stores, this will be just before the load
   * operation triggered by changing the store's sorters.</p>
   * <p>For locally sorted stores, this will be just before the data items in the store's
   * backing collection are sorted.</p>
   * @see ext.data.AbstractStore#remoteSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#event-beforesort Original Ext JS documentation of 'beforesort'
   * @see ext.data.AbstractStore
   * @eventType onBeforeSort
   */
  public static const BEFORE_SORT:String = "onBeforeSort";
  public static const __PARAMETER_SEQUENCE__:Array = ["store", "sorters", "eOpts"];

  public function AbstractStore_store_sortersEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  [ArrayElementType("ext.util.Sorter")]
  /**
   * Array of sorters applied to the store
   */
  public native function get sorters():Array;

  /**
   * The store being sorted
   */
  public native function get store():Store;
}
}