package ext.data.events {
import ext.data.Batch;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.Batch_operationEvent")]
public class Batch_operationEvent extends FlExtEvent {
  /**
   * Fired when all operations of this batch have been completed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#event-complete Original Ext JS documentation of 'complete'
   * @see ext.data.Batch
   * @eventType onComplete
   */
  public static const COMPLETE:String = "onComplete";
  /**
   * Fired when a operation encountered an exception
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#event-exception Original Ext JS documentation of 'exception'
   * @see ext.data.Batch
   * @eventType onException
   */
  public static const EXCEPTION:String = "onException";
  /**
   * Fired when each operation of the batch completes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#event-operationcomplete Original Ext JS documentation of 'operationcomplete'
   * @see ext.data.Batch
   * @eventType onOperationComplete
   */
  public static const OPERATION_COMPLETE:String = "onOperationComplete";
  public static const __PARAMETER_SEQUENCE__:Array = ["batch", "operation", "eOpts"];

  public function Batch_operationEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The batch object
   */
  public native function get batch():Batch;

  /**
   * The last operation that was executed
   */
  public native function get operation():Object;
}
}