package ext.data.events {
import ext.data.Connection;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.Connection_response_optionsEvent")]
public class Connection_response_optionsEvent extends FlExtEvent {
  /**
   * Fires if the request was successfully completed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#event-requestcomplete Original Ext JS documentation of 'requestcomplete'
   * @see ext.data.Connection
   * @eventType onRequestComplete
   */
  public static const REQUEST_COMPLETE:String = "onRequestComplete";
  /**
   * Fires if an error HTTP status was returned from the server. This event may also
   * be listened to in the event that a request has timed out or has been aborted.
   * See <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html">HTTP Status Code Definitions</a>
   * for details of HTTP status codes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#event-requestexception Original Ext JS documentation of 'requestexception'
   * @see ext.data.Connection
   * @eventType onRequestException
   */
  public static const REQUEST_EXCEPTION:String = "onRequestException";
  public static const __PARAMETER_SEQUENCE__:Array = ["conn", "response", "options", "eOpts"];

  public function Connection_response_optionsEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * This Connection object.
   */
  public native function get conn():Connection;

  /**
   * The options config object passed to the →<code>request()</code> method.
   * @see ext.data.Connection#request()
   */
  public native function get options():Object;

  /**
   * The XHR object containing the response data.
   * See <a href="http://www.w3.org/TR/XMLHttpRequest/">The XMLHttpRequest Object</a> for details.
   */
  public native function get response():Object;
}
}