package ext.data.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.NodeInterfaceEvent")]
public class NodeInterfaceEvent extends FlExtEvent {
  /**
   * Fires before this node is collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-beforecollapse Original Ext JS documentation of 'beforecollapse'
   * @see ext.data.NodeInterface
   * @eventType onBeforeCollapse
   */
  public static const BEFORE_COLLAPSE:String = "onBeforeCollapse";
  /**
   * Fires before this node is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-beforeexpand Original Ext JS documentation of 'beforeexpand'
   * @see ext.data.NodeInterface
   * @eventType onBeforeExpand
   */
  public static const BEFORE_EXPAND:String = "onBeforeExpand";
  /**
   * Fires when this node is collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-collapse Original Ext JS documentation of 'collapse'
   * @see ext.data.NodeInterface
   * @eventType onCollapse
   */
  public static const COLLAPSE:String = "onCollapse";
  /**
   * Fires when this node is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-expand Original Ext JS documentation of 'expand'
   * @see ext.data.NodeInterface
   * @eventType onExpand
   */
  public static const EXPAND:String = "onExpand";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function NodeInterfaceEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The collapsing node
   */
  public native function get source():NodeInterface;
}
}