package ext.data.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.NodeInterface_node_refNodeEvent")]
public class NodeInterface_node_refNodeEvent extends FlExtEvent {
  /**
   * Fires before a new child is inserted, return false to cancel the insert.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-beforeinsert Original Ext JS documentation of 'beforeinsert'
   * @see ext.data.NodeInterface
   * @eventType onBeforeInsert
   */
  public static const BEFORE_INSERT:String = "onBeforeInsert";
  /**
   * Fires when a new child node is inserted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-insert Original Ext JS documentation of 'insert'
   * @see ext.data.NodeInterface
   * @eventType onInsert
   */
  public static const INSERT:String = "onInsert";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "node", "refNode", "eOpts"];

  public function NodeInterface_node_refNodeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The child node to be inserted
   */
  public native function get node():NodeInterface;

  /**
   * The child node the node is being
   * inserted before
   */
  public native function get refNode():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}