package ext.data.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.NodeInterface_oldParent_newParent_indexEvent")]
public class NodeInterface_oldParent_newParent_indexEvent extends FlExtEvent {
  /**
   * Fires before this node is moved to a new location in the tree. Return false
   * to cancel the move.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-beforemove Original Ext JS documentation of 'beforemove'
   * @see ext.data.NodeInterface
   * @eventType onBeforeMove
   */
  public static const BEFORE_MOVE:String = "onBeforeMove";
  /**
   * Fires when this node is moved to a new location in the tree
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#event-move Original Ext JS documentation of 'move'
   * @see ext.data.NodeInterface
   * @eventType onMove
   */
  public static const MOVE:String = "onMove";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "oldParent", "newParent", "index", "eOpts"];

  public function NodeInterface_oldParent_newParent_indexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index it is being moved to
   */
  public native function get index():Number;

  /**
   * The new parent this node is moving
   * to
   */
  public native function get newParent():NodeInterface;

  /**
   * The parent of this node
   */
  public native function get oldParent():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}