package ext.data.events {
import ext.data.Store;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.ProxyStore_metaEvent")]
public class ProxyStore_metaEvent extends FlExtEvent {
  /**
   * Fires when this store's underlying reader (available via the proxy) provides new metadata.
   * Metadata usually consists of new field definitions, but can include any configuration data
   * required by an application, and can be processed as needed in the event handler.
   * This event is currently only fired for JsonReaders.
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#event-metachange Original Ext JS documentation of 'metachange'
   * @see ext.data.ProxyStore
   * @eventType onMetaChange
   */
  public static const META_CHANGE:String = "onMetaChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "meta", "eOpts"];

  public function ProxyStore_metaEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The JSON metadata
   */
  public native function get meta():Object;

  public native function get source():Store;
}
}