package ext.data.events {
import ext.data.Store;
import ext.data.operation.Operation;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.Store_records_successful_operationEvent")]
public class Store_records_successful_operationEvent extends FlExtEvent {
  /**
   * Fires whenever records have been prefetched.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Store.html#event-prefetch Original Ext JS documentation of 'prefetch'
   * @see ext.data.Store
   * @eventType onPrefetch
   */
  public static const PREFETCH:String = "onPrefetch";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "records", "successful", "operation", "eOpts"];

  public function Store_records_successful_operationEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The associated operation.
   */
  public native function get operation():Operation;

  [ArrayElementType("ext.data.Model")]
  /**
   * An array of records.
   */
  public native function get records():Array;

  public native function get source():Store;

  /**
   * <code>true</code> if the operation was successful.
   */
  public native function get successful():Boolean;
}
}