package ext.data.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.TreeStoreEvent")]
public class TreeStoreEvent extends FlExtEvent {
  /**
   * Fires before this node is collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodebeforecollapse Original Ext JS documentation of 'nodebeforecollapse'
   * @see ext.data.TreeStore
   * @eventType onNodeBeforeCollapse
   */
  public static const NODE_BEFORE_COLLAPSE:String = "onNodeBeforeCollapse";
  /**
   * Fires before this node is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodebeforeexpand Original Ext JS documentation of 'nodebeforeexpand'
   * @see ext.data.TreeStore
   * @eventType onNodeBeforeExpand
   */
  public static const NODE_BEFORE_EXPAND:String = "onNodeBeforeExpand";
  /**
   * Fires when this node is collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodecollapse Original Ext JS documentation of 'nodecollapse'
   * @see ext.data.TreeStore
   * @eventType onNodeCollapse
   */
  public static const NODE_COLLAPSE:String = "onNodeCollapse";
  /**
   * Fires when this node is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodeexpand Original Ext JS documentation of 'nodeexpand'
   * @see ext.data.TreeStore
   * @eventType onNodeExpand
   */
  public static const NODE_EXPAND:String = "onNodeExpand";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function TreeStoreEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The collapsing node
   */
  public native function get source():NodeInterface;
}
}