package ext.data.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.TreeStore_childNodesEvent")]
public class TreeStore_childNodesEvent extends FlExtEvent {
  /**
   * Fires when this node's childNodes are sorted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodesort Original Ext JS documentation of 'nodesort'
   * @see ext.data.TreeStore
   * @eventType onNodeSort
   */
  public static const NODE_SORT:String = "onNodeSort";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "childNodes", "eOpts"];

  public function TreeStore_childNodesEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  [ArrayElementType("ext.data.NodeInterface")]
  /**
   * The childNodes of this node.
   */
  public native function get childNodes():Array;

  /**
   * This node.
   */
  public native function get source():NodeInterface;
}
}