package ext.data.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.TreeStore_node_indexEvent")]
public class TreeStore_node_indexEvent extends FlExtEvent {
  /**
   * Fires when a new child node is appended
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodeappend Original Ext JS documentation of 'nodeappend'
   * @see ext.data.TreeStore
   * @eventType onNodeAppend
   */
  public static const NODE_APPEND:String = "onNodeAppend";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "node", "index", "eOpts"];

  public function TreeStore_node_indexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index of the newly appended node
   */
  public native function get index():Number;

  /**
   * The newly appended node
   */
  public native function get node():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}