package ext.data.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.events.TreeStore_oldParent_newParent_indexEvent")]
public class TreeStore_oldParent_newParent_indexEvent extends FlExtEvent {
  /**
   * Fires before this node is moved to a new location in the tree. Return false
   * to cancel the move.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodebeforemove Original Ext JS documentation of 'nodebeforemove'
   * @see ext.data.TreeStore
   * @eventType onNodeBeforeMove
   */
  public static const NODE_BEFORE_MOVE:String = "onNodeBeforeMove";
  /**
   * Fires when this node is moved to a new location in the tree
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.TreeStore.html#event-nodemove Original Ext JS documentation of 'nodemove'
   * @see ext.data.TreeStore
   * @eventType onNodeMove
   */
  public static const NODE_MOVE:String = "onNodeMove";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "oldParent", "newParent", "index", "eOpts"];

  public function TreeStore_oldParent_newParent_indexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index it is being moved to
   */
  public native function get index():Number;

  /**
   * The new parent this node is moving
   * to
   */
  public native function get newParent():NodeInterface;

  /**
   * The parent of this node
   */
  public native function get oldParent():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}