package ext.data.field {

[Native("Ext.data.field.Array", require)]
/**
 * A data field that deals with array values. See the →<code>itemType</code> config for controlling
 * the array elements.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('Task', {
 *     extend: 'Ext.data.Model',
 *     fields: [{
 *         name: 'milestoneDates',
 *         type: 'array',
 *         itemType: {
 *             type: 'date',
 *             dateFormat: 'Y-m-d'
 *         }
 *     }]
 * });
 *
 * var record = Ext.create('Task', { milestoneDates: [
 *     '2010-01-01',
 *     '2010-02-01',
 *     '2010-03-01'
 * ]}), value = record.get('milestoneDates');
 *
 * Ext.toast(value.join(', '));
 * </pre>
 * @see #itemType
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Array.html Original Ext JS documentation of 'Ext.data.field.Array'
 */
public class ArrayDataField extends DataField {
  /**
   * @inheritDoc
   */
  public function ArrayDataField(config:ArrayDataField = null) {
    super();
  }

  [ExtConfig]
  /**
   * Controls the individual elements of the array. This is a field type or configuration
   * that is used to →<code>collate()</code>, →<code>compare()</code>, <i>compare equality</i> (→<code>isEqual()</code>),
   * →<code>convert</code> and →<code>deserialize</code> each element.
   * @default {
   *     type: 'auto'
   * }
   * @see #collate()
   * @see #compare()
   * @see #isEqual()
   * @see #convert
   * @see #deserialize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Array.html#cfg-itemType Original Ext JS documentation of 'itemType'
   */
  public native function get itemType():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemType(value:*):void;
}
}