package ext.data.field {

[Native("Ext.data.field.Boolean", require)]
/**
 * A data field that automatically <i>converts</i> (→<code>convert</code>) its value to a boolean.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('Task', {
 *     extend: 'Ext.data.Model',
 *     fields: [
 *         { name: 'completed', type: 'boolean' }
 *     ]
 * });
 *
 * var record = Ext.create('Task', { completed: true }),
 *     value = record.get('completed');
 *
 * Ext.toast("completed is " + value);
 * </pre>
 * @see #convert
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Boolean.html Original Ext JS documentation of 'Ext.data.field.Boolean'
 */
public class BooleanField extends DataField {
  /**
   * @param config @inheritDoc
   */
  public function BooleanField(config:BooleanField = null) {
    super();
  }

  /**
   * Values matching this regular expression are considered <code>true</code>.
   * @default /^\s&#42;(?:true|yes|on|1)\s&#42;$/i
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Boolean.html#property-trueRe Original Ext JS documentation of 'trueRe'
   */
  public native function get trueRe():*;

  /**
   * @private
   */
  public native function set trueRe(value:*):void;
}
}