package ext.data.field {

[Native("Ext.data.field.Date", require)]
/**
 * A data field that automatically <i>converts</i> (→<code>convert</code>) its value to a date.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('User', {
 *     extend: 'Ext.data.Model',
 *     fields: [
 *         { name: 'birthDate', type: 'date' }
 *     ]
 * });
 *
 * var record = Ext.create('User', { birthDate: 'Tuesday, June 27, 2017' }),
 *     value = record.get('birthDate');
 *
 * Ext.toast("birthDate is " + value);
 * </pre>
 * @see #convert
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html Original Ext JS documentation of 'Ext.data.field.Date'
 */
public class DateDataField extends DataField {
  /**
   * @param config @inheritDoc
   */
  public function DateDataField(config:DateDataField = null) {
    super();
  }

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * Serves as a default for the →<code>dateReadFormat</code> and →<code>dateWriteFormat</code> config
   * options. This will be used in place of those other configurations if not specified.
   * <p>A format string for the →<code>ext.DateUtil.parse()</code> function, or "timestamp"
   * if the value provided by the Reader is a UNIX timestamp, or "time" if the value provided by
   * the Reader is a javascript millisecond timestamp. See →<code>ext.DateUtil</code>.</p>
   * <p>It is quite important to note that while this config is optional, it will default to using
   * the base JavaScript Date object's <code>parse</code> function if not specified, rather than
   * →<code>ext.DateUtil.parse()</code>. This can cause unexpected issues, especially when
   * converting between timezones, or when converting dates that do not have a timezone specified.
   * The behavior of the native <code>Date.parse</code> is implementation-specific, and depending on the
   * value of the date string, it might return the UTC date or the local date. <b>For this reason
   * it is strongly recommended that you always specify an explicit date format when parsing
   * dates.</b></p>
   * @see #dateReadFormat
   * @see #dateWriteFormat
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see ext.#DateUtil ext.DateUtil
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html#cfg-dateFormat Original Ext JS documentation of 'dateFormat'
   * @see #getDateFormat()
   */
  public native function get dateFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dateFormat(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * Used when converting received data into a Date when the →<code>type</code> is specified as
   * <code>"date"</code>. This configuration takes precedence over →<code>dateFormat</code>.
   * See →<code>dateFormat</code> for more information.
   * @see #type
   * @see #dateFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html#cfg-dateReadFormat Original Ext JS documentation of 'dateReadFormat'
   * @see #getDateReadFormat()
   */
  public native function get dateReadFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dateReadFormat(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * Provides a custom format when serializing dates with a →<code>ext.data.writer.DataWriter</code>.
   * If this is not specified, the →<code>dateFormat</code> will be used. If no <code>→dateFormat</code>
   * is specified, 'timestamp' format is used.
   * <p>See the →<code>ext.data.writer.DataWriter</code> docs for more information on writing dates.</p>
   * <p><b>Note</b> It is not possible to use the standard date serialization pathway or
   * <i>native browser JSON production</i> (→<code>ext.Ext.USE_NATIVE_JSON</code>) to use a
   * →<code>ext.data.writer.JsonWriter</code> to send Microsoft formated "JSON" dates.</p>
   * <p>To use a →<code>ext.data.writer.JsonWriter</code> to write dates in a JSON packet in
   * the form <code>"\/Date(1357372800000)\/"</code> configure the field like this:</p>
   * <pre>
   * {
   *     type: 'date',
   *     dateFormat: 'MS',     // To parse incoming dates from server correctly
   *     serialize: null       // Avoid formatting or conversion by the Writer
   * }
   * </pre>
   * <p>Then override the <code>→ext.JSON</code> date serialize function:</p>
   * <pre>
   * Ext.JSON.encodeDate = function (d) {
   *     return '"' + Ext.Date.format(d, 'MS') + '"';
   * };
   * </pre>
   * @see ext.data.writer.DataWriter
   * @see #dateFormat
   * @see ext.SExt#USE_NATIVE_JSON ext.Ext.USE_NATIVE_JSON
   * @see ext.data.writer.JsonWriter
   * @see ext.#JSON ext.JSON
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html#cfg-dateWriteFormat Original Ext JS documentation of 'dateWriteFormat'
   * @see #getDateWriteFormat()
   */
  public native function get dateWriteFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dateWriteFormat(value:String):void;

  [ExtConfig]
  /**
   * Used to manually set strict date parsing on a per-field basis. If no <code>→useStrict</code>
   * is specified, will use value of →<code>ext.DateUtil.useStrict</code> to determine how to
   * process dates.
   * @since 6.2.0
   * @see #useStrict
   * @see ext.SDateUtil#useStrict ext.DateUtil.useStrict
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html#cfg-useStrict Original Ext JS documentation of 'useStrict'
   */
  public native function get useStrict():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useStrict(value:Boolean):void;

  /**
   * Gets the dateFormat for this field. See →<code>dateFormat</code>.
   * @return dateFormat
   * @see #dateFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html#method-getDateFormat Original Ext JS documentation of 'getDateFormat'
   */
  public native function getDateFormat():String;

  /**
   * Gets the dateReadFormat for this field. See →<code>dateReadFormat</code>.
   * @return dateReadFormat
   * @see #dateReadFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html#method-getDateReadFormat Original Ext JS documentation of 'getDateReadFormat'
   */
  public native function getDateReadFormat():String;

  /**
   * Gets the dateWriteFormat for this field. See →<code>dateWriteFormat</code>.
   * @return dateWriteFormat
   * @see #dateWriteFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Date.html#method-getDateWriteFormat Original Ext JS documentation of 'getDateWriteFormat'
   */
  public native function getDateWriteFormat():String;
}
}