package ext.data.field {

[Native("Ext.data.field.Integer", require)]
/**
 * A data field that automatically <i>converts</i> (→<code>convert</code>) its value to an integer.
 * <p><b>Note:</b> As you can see in the example below, casting data as an integer
 * can result in a loss of precision. (5.1 is converted to 5).</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('User', {
 *     extend: 'Ext.data.Model',
 *     fields: [
 *         { name: 'age', type: 'integer' }
 *     ]
 * });
 *
 * var record = Ext.create('User', { age: "5.1" }),
 *     value = record.get('age');
 *
 * Ext.toast("age is " + value);
 * </pre>
 * @see #convert
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Integer.html Original Ext JS documentation of 'Ext.data.field.Integer'
 */
public class IntegerDataField extends DataField {
  /**
   * @param config @inheritDoc
   */
  public function IntegerDataField(config:IntegerDataField = null) {
    super();
  }
}
}