package ext.data.field {

[Native("Ext.data.field.Number", require)]
/**
 * A data field that automatically <i>converts</i> (→<code>convert</code>) its value to a floating-point
 * number.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('Product', {
 *     extend: 'Ext.data.Model',
 *     fields: [
 *         { name: 'price', type: 'number' }
 *     ]
 * });
 *
 * var record = Ext.create('Product', { price: "5.1" }),
 *     value = record.get('price');
 *
 * Ext.toast("price is " + value);
 * </pre>
 * @see #convert
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.Number.html Original Ext JS documentation of 'Ext.data.field.Number'
 */
public class NumberDataField extends IntegerDataField {
  /**
   * @param config @inheritDoc
   */
  public function NumberDataField(config:NumberDataField = null) {
    super();
  }
}
}