package ext.data.field {

[Native("Ext.data.field.String", require)]
/**
 * A data field that automatically <i>converts</i> (→<code>convert</code>) its value to a string.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('User', {
 *     extend: 'Ext.data.Model',
 *     fields: [
 *         { name: 'firstName', type: 'string' }
 *     ]
 * });
 *
 * var record = Ext.create('User', { firstName: "Phil" }),
 *     value = record.get('firstName');
 *
 * Ext.toast("firstName is " + value);
 * </pre>
 * @see #convert
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.field.String.html Original Ext JS documentation of 'Ext.data.field.String'
 */
public class StringDataField extends DataField {
  /**
   * @param config @inheritDoc
   */
  public function StringDataField(config:StringDataField = null) {
    super();
  }
}
}