package ext.data.identifier {

[Native("Ext.data.identifier.Negative", require)]
/**
 * This class id generator produces successive negative numbers for id's. That is, -1, -2,
 * etc..
 * <p>The advantage of this type of <code>identifier</code> is that these are seldom valid server-side
 * id values (which typically start at 1 and increase from there) but are of the same
 * data type (integer). This means that these values can typically be deserialized by a
 * server and then recognized as provisionally generated.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Negative.html Original Ext JS documentation of 'Ext.data.identifier.Negative'
 */
public class NegativeIdentifier extends SequentialIdentifier {
  /**
   * @param config @inheritDoc
   */
  public function NegativeIdentifier(config:NegativeIdentifier = null) {
    super();
  }
}
}