package ext.data.identifier {

[Native("Ext.data.identifier.Sequential", require)]
/**
 * This class is a sequential id generator. A simple use of this class would be like so:
 * <pre>
 * Ext.define('MyApp.data.MyModel', {
 *     extend: 'Ext.data.Model',
 *     identifier: 'sequential'
 * });
 * // assign id's of 1, 2, 3, etc.
 * </pre>
 * <p>An example of a configured generator would be:</p>
 * <pre>
 * Ext.define('MyApp.data.MyModel', {
 *     extend: 'Ext.data.Model',
 *     identifier: {
 *         type: 'sequential',
 *         prefix: 'ID_',
 *         seed: 1000,
 *         increment: 10
 *     }
 * });
 * // assign id's of ID_1000, ID_1010, ID_1020, etc.
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Sequential.html Original Ext JS documentation of 'Ext.data.identifier.Sequential'
 */
public class SequentialIdentifier extends GeneratorIdentifier {
  /**
   * @param config @inheritDoc
   */
  public function SequentialIdentifier(config:SequentialIdentifier = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The number by which to adjust the <code>→seed</code> after for the next sequential id.
   * @default 1
   * @see #seed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Sequential.html#cfg-increment Original Ext JS documentation of 'increment'
   * @see #getIncrement()
   * @see #setIncrement()
   */
  public native function get increment():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set increment(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The string to place in front of the sequential number for each generated id.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Sequential.html#cfg-prefix Original Ext JS documentation of 'prefix'
   * @see #getPrefix()
   * @see #setPrefix()
   */
  public native function get prefix():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set prefix(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number at which to start generating sequential id's.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Sequential.html#cfg-seed Original Ext JS documentation of 'seed'
   * @see #getSeed()
   * @see #setSeed()
   */
  public native function get seed():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set seed(value:Number):void;

  /**
   * Generates and returns the next id.
   * @return The next id. If a →<code>prefix</code> was specified, returns
   * a String, otherwise returns a Number.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Sequential.html#method-generate Original Ext JS documentation of 'generate'
   * @see #prefix
   */
  override public native function generate():*;

  /**
   * Returns the value of <code>increment</code>.
   * @see #increment
   */
  public native function getIncrement():Number;

  /**
   * Returns the value of <code>prefix</code>.
   * @see #prefix
   */
  public native function getPrefix():String;

  /**
   * Returns the value of <code>seed</code>.
   * @see #seed
   */
  public native function getSeed():Number;

  /**
   * Sets the value of <code>increment</code>.
   * @param increment The new value.
   * @see #increment
   */
  public native function setIncrement(increment:Number):void;

  /**
   * Sets the value of <code>prefix</code>.
   * @param prefix The new value.
   * @see #prefix
   */
  public native function setPrefix(prefix:String):void;

  /**
   * Sets the value of <code>seed</code>.
   * @param seed The new value.
   * @see #seed
   */
  public native function setSeed(seed:Number):void;
}
}