package ext.data.identifier {

[Native("Ext.data.identifier.Uuid", require)]
/**
 * This class generates UUID's according to RFC 4122. This class has a default id property.
 * This means that a single instance is shared unless the id property is overridden. Thus,
 * two →<code>ext.data.Model</code> instances configured like the following share one generator:
 * <pre>
 * Ext.define('MyApp.data.MyModelX', {
 *     extend: 'Ext.data.Model',
 *     identifier: 'uuid'
 * });
 *
 * Ext.define('MyApp.data.MyModelY', {
 *     extend: 'Ext.data.Model',
 *     identifier: 'uuid'
 * });
 * </pre>
 * <p>This allows all models using this class to share a commonly configured instance.</p>
 * <p><b>Using Version 1 ("Sequential") UUID's</b></p>
 * <p>If a server can provide a proper timestamp and a "cryptographic quality random number"
 * (as described in RFC 4122), the shared instance can be configured as follows:</p>
 * <pre>
 * Ext.data.identifier.Uuid.Global.reconfigure({
 *     version: 1,
 *     clockSeq: clock, // 14 random bits
 *     salt: salt,      // 48 secure random bits (the Node field)
 *     timestamp: ts    // timestamp per Section 4.1.4
 * });
 *
 * // or these values can be split into 32-bit chunks:
 *
 * Ext.data.identifier.Uuid.Global.reconfigure({
 *     version: 1,
 *     clockSeq: clock,
 *     salt: { lo: saltLow32, hi: saltHigh32 },
 *     timestamp: { lo: timestampLow32, hi: timestamptHigh32 }
 * });
 * </pre>
 * <p>This approach improves the generator's uniqueness by providing a valid timestamp and
 * higher quality random data. Version 1 UUID's should not be used unless this information
 * can be provided by a server and care should be taken to avoid caching of this data.</p>
 * <p>See <a href="http://www.ietf.org/rfc/rfc4122.txt">http://www.ietf.org/rfc/rfc4122.txt</a> for details.</p>
 * @see ext.data.Model
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Uuid.html Original Ext JS documentation of 'Ext.data.identifier.Uuid'
 */
public class UuidIdentifier extends GeneratorIdentifier {
  /**
   * @param config @inheritDoc
   */
  public function UuidIdentifier(config:UuidIdentifier = null) {
    super();
  }

  [ExtConfig]
  /**
   * A clock value to help avoid duplicates.
   * <p>Only applicable when <code>→version</code> is set to <code>1</code>.</p>
   * @see #version
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Uuid.html#cfg-clockSeq Original Ext JS documentation of 'clockSeq'
   */
  public native function get clockSeq():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clockSeq(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The id for this generator instance. By default all model instances share the same
   * UUID generator instance. By specifying an id other than 'uuid', a unique generator
   * instance will be created for the Model.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Uuid.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   * @see #setId()
   */
  override public native function get id():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set id(value:String):void;

  [ExtConfig]
  /**
   * This value is a 48-bit number. This can be a number or an object with <code>hi</code> and <code>lo</code>
   * properties where <code>lo</code> is the low 32-bits and <code>hi</code> is the upper 16 bits.
   * <p>Only applicable when <code>→version</code> is set to <code>1</code>.</p>
   * @see #version
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Uuid.html#cfg-salt Original Ext JS documentation of 'salt'
   */
  public native function get salt():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set salt(value:*):void;

  [ExtConfig]
  /**
   * When created, this value is a 60-bit number. This can be a number or an object with
   * <code>hi</code> and <code>lo</code> properties where <code>lo</code> is the low 32-bits and <code>hi</code> is the upper 28 bits.
   * <p>Only applicable when <code>→version</code> is set to <code>1</code>.</p>
   * @see #version
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Uuid.html#cfg-timestamp Original Ext JS documentation of 'timestamp'
   */
  public native function get timestamp():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set timestamp(value:*):void;

  [ExtConfig]
  /**
   * The Version of UUID. Supported values are:
   * <ul>
   * <li>
   * <p>1 : Time-based, "sequential" UUID. To use this type of generator, you must also
   * specify the <code>→salt</code>, <code>→timestamp</code> and <code>clock</code> properties. For details on the values
   * and how a server should produce them, see RFC 4122. Use of this type of generator
   * produces values that are easier to read since they are sequential, but requires
   * some care to initialize properly and still ensure their uniqueness.</p>
   * </li>
   * <li>
   * <p>4 : Pseudo-random UUID. This is the simplest form and requires no configuration
   * and hence is the default type.</p>
   * </li>
   * </ul>
   * @default 4
   * @see #salt
   * @see #timestamp
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Uuid.html#cfg-version Original Ext JS documentation of 'version'
   */
  public native function get version():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set version(value:Number):void;

  /**
   * Returns the value of <code>id</code>.
   * @see #id
   */
  override public native function getId():String;

  /**
   * Reconfigures this generator given new config properties. The only values that this
   * changes are <code>→version</code> and, if <code>→version</code> is 1, its related config properties.
   * @see #version
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.identifier.Uuid.html#method-reconfigure Original Ext JS documentation of 'reconfigure'
   */
  public native function reconfigure(config:*):void;

  /**
   * Sets the value of <code>id</code>.
   * @param id The new value.
   * @see #id
   */
  override public native function setId(id:String):void;
}
}