package ext.data.operation {
import ext.Base;
import ext.data.Batch;
import ext.data.Request;
import ext.data.ResultSet;
import ext.data.proxy.DataProxy;

[Native("Ext.data.operation.Operation", require)]
/**
 * Represents a read or write operation performed by a →<code>ext.data.proxy.DataProxy</code>.
 * Operation objects are used to enable communication between Stores and Proxies.
 * Application developers should rarely need to interact with Operation objects directly.
 * <p>Several Operations can be batched together in a <i>batch</i> (→<code>ext.data.Batch</code>).</p>
 * @see ext.data.proxy.DataProxy
 * @see ext.data.Batch
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html Original Ext JS documentation of 'Ext.data.operation.Operation'
 */
public class Operation extends Base {
  /**
   * Creates new Operation object.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Operation(config:Operation = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The batch for this operation, if applicable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-batch Original Ext JS documentation of 'batch'
   * @see #getBatch()
   * @see #setBatch()
   */
  public native function get batch():Batch;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set batch(value:Batch):void;

  [ExtConfig]
  [Bindable]
  /**
   * Function to execute when operation completed.
   * @default undefined
   * <ul>
   * <li><code>records:Array</code> (optional) —
   * Array of records.
   * </li>
   * <li><code>operation:ext.data.operation.Operation</code> (optional) —
   * The Operation itself.
   * </li>
   * <li><code>success:Boolean</code> (optional) —
   * True when operation completed successfully.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-callback Original Ext JS documentation of 'callback'
   * @see #getCallback()
   * @see #setCallback()
   */
  public native function get callback():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set callback(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * The id of the operation.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   * @see #setId()
   */
  public native function get id():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set id(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Parameters to pass along with the request when performing the operation.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-params Original Ext JS documentation of 'params'
   * @see #getParams()
   * @see #setParams()
   */
  public native function get params():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set params(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The proxy for this operation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-proxy Original Ext JS documentation of 'proxy'
   * @see #getProxy()
   * @see #setProxy()
   */
  public native function get proxy():DataProxy;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set proxy(value:DataProxy):void;

  [ArrayElementType("ext.data.Model")]
  [ExtConfig]
  [Bindable]
  /**
   * The records associated with this operation. If this is a <code>read</code> operation, this will be
   * <code>null</code> until data is returned from the →<code>ext.data.proxy.DataProxy</code>.
   * @see ext.data.proxy.DataProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-records Original Ext JS documentation of 'records'
   * @see #getRecords()
   * @see #setRecords()
   */
  public native function get records():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set records(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The request for this operation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-request Original Ext JS documentation of 'request'
   * @see #getRequest()
   * @see #setRequest()
   */
  public native function get request():Request;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set request(value:Request):void;

  [ExtConfig]
  [Bindable]
  /**
   * The ResultSet for this operation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-resultSet Original Ext JS documentation of 'resultSet'
   * @see #getResultSet()
   * @see #setResultSet()
   */
  public native function get resultSet():ResultSet;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set resultSet(value:ResultSet):void;

  [ExtConfig]
  [Bindable]
  /**
   * Scope for the →<code>callback</code> function.
   * @default undefined
   * @see #callback
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-scope Original Ext JS documentation of 'scope'
   * @see #getScope()
   * @see #setScope()
   */
  public native function get scope():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * True if this Operation is to be executed synchronously. This property is inspected by a
   * →<code>ext.data.Batch</code> to see if a series of Operations can be executed in parallel
   * or not.
   * @default false
   * @see ext.data.Batch
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-synchronous Original Ext JS documentation of 'synchronous'
   * @see #getSynchronous()
   * @see #setSynchronous()
   */
  public native function get synchronous():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set synchronous(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The url for this operation. Typically this will be provided by a proxy and not configured
   * here.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#cfg-url Original Ext JS documentation of 'url'
   * @see #getUrl()
   * @see #setUrl()
   */
  public native function get url():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set url(value:String):void;

  /**
   * Aborts the processing of this operation on the →<code>proxy</code>.
   * This is only valid for proxies that make asynchronous requests.
   * @see #proxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-abort Original Ext JS documentation of 'abort'
   */
  public native function abort():void;

  /**
   * Checks whether this operation should cause writing to occur.
   * @return Whether the operation should cause a write to occur.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-allowWrite Original Ext JS documentation of 'allowWrite'
   */
  public native function allowWrite():Boolean;

  /**
   * Process records in the operation after the response is successful and the result
   * set is parsed correctly. The base class implementation of this method is used by
   * "create" and "update" operations to allow the server response to update the client
   * side records.
   * @param resultSet The result set
   * @param request The request
   * @param response The response
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-doProcess Original Ext JS documentation of 'doProcess'
   */
  protected native function doProcess(resultSet:ResultSet, request:Request, response:Object):void;

  /**
   * Returns the value of <code>batch</code>.
   * @see #batch
   */
  public native function getBatch():Batch;

  /**
   * Returns the value of <code>callback</code>.
   * @see #callback
   */
  public native function getCallback():Function;

  /**
   * Returns the error string or object that was set using →<code>setException()</code>
   * @return The error object
   * @see #setException()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-getError Original Ext JS documentation of 'getError'
   */
  public native function getError():*;

  /**
   * Returns the value of <code>id</code>.
   * @see #id
   */
  public native function getId():Object;

  /**
   * Returns the value of <code>params</code>.
   * @see #params
   */
  public native function getParams():Object;

  /**
   * Returns the value of <code>proxy</code>.
   * @see #proxy
   */
  public native function getProxy():DataProxy;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns the <i>record</i> (→<code>ext.data.Model</code>)s associated with this operation. For read
   * operations the records as set by the →<code>ext.data.proxy.DataProxy</code> will be
   * returned (returns <code>null</code> if the proxy has not yet set the records).
   * <p>For create, update, and destroy operations the operation's initially configured
   * records will be returned, although the proxy may modify these records' data at some
   * point after the operation is initialized.</p>
   * @see ext.data.Model
   * @see ext.data.proxy.DataProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-getRecords Original Ext JS documentation of 'getRecords'
   */
  public native function getRecords():Array;

  /**
   * Returns the value of <code>request</code>.
   * @see #request
   */
  public native function getRequest():Request;

  /**
   * Returns the value of <code>resultSet</code>.
   * @see #resultSet
   */
  public native function getResultSet():ResultSet;

  /**
   * Returns the value of <code>scope</code>.
   * @see #scope
   */
  public native function getScope():Object;

  /**
   * Returns the value of <code>synchronous</code>.
   * @see #synchronous
   */
  public native function getSynchronous():Boolean;

  /**
   * Returns the value of <code>url</code>.
   * @see #url
   */
  public native function getUrl():String;

  /**
   * Returns true if this Operation encountered an exception (see also →<code>getError()</code>)
   * @return True if there was an exception
   * @see #getError()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-hasException Original Ext JS documentation of 'hasException'
   */
  public native function hasException():Boolean;

  /**
   * Returns true if the Operation has been completed
   * @return True if the Operation is complete
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-isComplete Original Ext JS documentation of 'isComplete'
   */
  public native function isComplete():Boolean;

  /**
   * Returns true if the Operation has been started but has not yet completed.
   * @return True if the Operation is currently running
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-isRunning Original Ext JS documentation of 'isRunning'
   */
  public native function isRunning():Boolean;

  /**
   * Returns true if the Operation has been started. Note that the Operation may have started
   * AND completed, see →<code>isRunning()</code> to test if the Operation is currently running.
   * @return True if the Operation has started
   * @see #isRunning()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-isStarted Original Ext JS documentation of 'isStarted'
   */
  public native function isStarted():Boolean;

  /**
   * Sets the value of <code>batch</code>.
   * @param batch The new value.
   * @see #batch
   */
  public native function setBatch(batch:Batch):void;

  /**
   * Sets the value of <code>callback</code>.
   * @param callback The new value.
   * @see #callback
   */
  public native function setCallback(callback:Function):void;

  /**
   * Marks the Operation as completed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-setCompleted Original Ext JS documentation of 'setCompleted'
   */
  public native function setCompleted():void;

  /**
   * Marks the Operation as having experienced an exception. Can be supplied with an option
   * error message/object.
   * @param error error string/object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-setException Original Ext JS documentation of 'setException'
   */
  public native function setException(error:* = undefined):void;

  /**
   * Sets the value of <code>id</code>.
   * @param id The new value.
   * @see #id
   */
  public native function setId(id:Object):void;

  /**
   * Sets the value of <code>params</code>.
   * @param params The new value.
   * @see #params
   */
  public native function setParams(params:Object):void;

  /**
   * Sets the value of <code>proxy</code>.
   * @param proxy The new value.
   * @see #proxy
   */
  public native function setProxy(proxy:DataProxy):void;

  [ArrayElementType("ext.data.Model")]
  /**
   * Sets the value of <code>records</code>.
   * @param records The new value.
   * @see #records
   */
  public native function setRecords(records:Array):void;

  /**
   * Sets the value of <code>request</code>.
   * @param request The new value.
   * @see #request
   */
  public native function setRequest(request:Request):void;

  /**
   * Sets the value of <code>resultSet</code>.
   * @param resultSet The new value.
   * @see #resultSet
   */
  public native function setResultSet(resultSet:ResultSet):void;

  /**
   * Sets the value of <code>scope</code>.
   * @param scope The new value.
   * @see #scope
   */
  public native function setScope(scope:Object):void;

  /**
   * Marks the Operation as started.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-setStarted Original Ext JS documentation of 'setStarted'
   */
  public native function setStarted():void;

  /**
   * Marks the Operation as successful.
   * @param complete <code>true</code> to also mark this operation
   * as being complete See →<code>setCompleted()</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-setSuccessful Original Ext JS documentation of 'setSuccessful'
   * @see #setCompleted()
   */
  public native function setSuccessful(complete:Boolean = false):void;

  /**
   * Sets the value of <code>synchronous</code>.
   * @param synchronous The new value.
   * @see #synchronous
   */
  public native function setSynchronous(synchronous:Boolean):void;

  /**
   * Sets the value of <code>url</code>.
   * @param url The new value.
   * @see #url
   */
  public native function setUrl(url:String):void;

  /**
   * Returns true if the Operation has completed and was successful
   * @return True if successful
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Operation.html#method-wasSuccessful Original Ext JS documentation of 'wasSuccessful'
   */
  public native function wasSuccessful():Boolean;
}
}