package ext.data.operation {
import ext.util.Grouper;

[Native("Ext.data.operation.Read", require)]
/**
 * Encapsulates a read operation as performed by a <i>proxy</i> (→<code>ext.data.proxy.DataProxy</code>).
 * <p>This class is instantiated by <i>stores</i> (→<code>ext.data.Store</code>) and <i>records</i> (→<code>ext.data.Model</code>)
 * and should not need to be instantiated in user code.</p>
 * @see ext.data.proxy.DataProxy
 * @see ext.data.Store
 * @see ext.data.Model
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Read.html Original Ext JS documentation of 'Ext.data.operation.Read'
 */
public class ReadOperation extends Operation {
  /**
   * @param config @inheritDoc
   */
  public function ReadOperation(config:ReadOperation = null) {
    super();
  }

  [ArrayElementType("ext.util.Filter")]
  [ExtConfig]
  [Bindable]
  /**
   * Optional array of filter objects. Only applies to 'read' actions.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Read.html#cfg-filters Original Ext JS documentation of 'filters'
   * @see #getFilters()
   * @see #setFilters()
   */
  public native function get filters():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set filters(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * Optional grouping configuration. Only applies to 'read' actions where grouping is
   * desired.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Read.html#cfg-grouper Original Ext JS documentation of 'grouper'
   * @see #getGrouper()
   * @see #setGrouper()
   */
  public native function get grouper():Grouper;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set grouper(value:Grouper):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of records to load. Used on 'read' actions when paging is being used.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Read.html#cfg-limit Original Ext JS documentation of 'limit'
   * @see #getLimit()
   * @see #setLimit()
   */
  public native function get limit():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set limit(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The page for this operation.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Read.html#cfg-page Original Ext JS documentation of 'page'
   * @see #getPage()
   * @see #setPage()
   */
  public native function get page():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set page(value:Number):void;

  [ArrayElementType("ext.util.Sorter")]
  [ExtConfig]
  [Bindable]
  /**
   * Optional array of sorter objects. Only applies to 'read' actions.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Read.html#cfg-sorters Original Ext JS documentation of 'sorters'
   * @see #getSorters()
   * @see #setSorters()
   */
  public native function get sorters():Array;

  [ExtConfig]
  [Bindable]
  [ArrayElementType("ext.util.Sorter")]
  /**
   * @private
   */
  public native function set sorters(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The start index (offset), used in paging when running a 'read' action.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.operation.Read.html#cfg-start Original Ext JS documentation of 'start'
   * @see #getStart()
   * @see #setStart()
   */
  public native function get start():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set start(value:Number):void;

  [ArrayElementType("ext.util.Filter")]
  /**
   * Returns the value of <code>filters</code>.
   * @see #filters
   */
  public native function getFilters():Array;

  /**
   * Returns the value of <code>grouper</code>.
   * @see #grouper
   */
  public native function getGrouper():Grouper;

  /**
   * Returns the value of <code>limit</code>.
   * @see #limit
   */
  public native function getLimit():Number;

  /**
   * Returns the value of <code>page</code>.
   * @see #page
   */
  public native function getPage():Number;

  [ArrayElementType("ext.util.Sorter")]
  /**
   * Returns the value of <code>sorters</code>.
   * @see #sorters
   */
  public native function getSorters():Array;

  /**
   * Returns the value of <code>start</code>.
   * @see #start
   */
  public native function getStart():Number;

  [ArrayElementType("ext.util.Filter")]
  /**
   * Sets the value of <code>filters</code>.
   * @param filters The new value.
   * @see #filters
   */
  public native function setFilters(filters:Array):void;

  /**
   * Sets the value of <code>grouper</code>.
   * @param grouper The new value.
   * @see #grouper
   */
  public native function setGrouper(grouper:Grouper):void;

  /**
   * Sets the value of <code>limit</code>.
   * @param limit The new value.
   * @see #limit
   */
  public native function setLimit(limit:Number):void;

  /**
   * Sets the value of <code>page</code>.
   * @param page The new value.
   * @see #page
   */
  public native function setPage(page:Number):void;

  [ArrayElementType("ext.util.Sorter")]
  /**
   * Sets the value of <code>sorters</code>.
   * @param sorters The new value.
   * @see #sorters
   */
  public native function setSorters(sorters:Array):void;

  /**
   * Sets the value of <code>start</code>.
   * @param start The new value.
   * @see #start
   */
  public native function setStart(start:Number):void;
}
}