package ext.data.proxy {

[Native("Ext.data.proxy.Client", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Base class for any client-side storage. Used as a superclass for
 * →<code>ext.data.proxy.MemoryProxy</code> and <i>Web Storage</i> (→<code>ext.data.proxy.WebStorageProxy</code>) proxies.
 * Do not use directly, use one of the subclasses instead.</p>
 * @see ext.data.proxy.MemoryProxy
 * @see ext.data.proxy.WebStorageProxy
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Client.html Original Ext JS documentation of 'Ext.data.proxy.Client'
 */
public class ClientProxy extends DataProxy {
  /**
   * @inheritDoc
   */
  public function ClientProxy(config:DataProxy = null) {
    super();
  }

  /**
   * <code>true</code> in this class to identify that requests made on this proxy are
   * performed synchronously
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Client.html#property-isSynchronous Original Ext JS documentation of 'isSynchronous'
   */
  override public native function get isSynchronous():Boolean;

  /**
   * @private
   */
  override public native function set isSynchronous(value:Boolean):void;

  /**
   * Abstract function that must be implemented by each ClientProxy subclass. This should purge
   * all record data from the client side storage, as well as removing any supporting data
   * (such as lists of record IDs)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Client.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;
}
}