package ext.data.proxy {
import ext.data.Batch;
import ext.data.operation.Operation;
import ext.mixin.IFactoryable;
import ext.mixin.Observable;

[Native("Ext.data.proxy.Proxy", require)]
[ExtConfig]
/**
 * @see ext.data.proxy.events.DataProxy_metaEvent.META_CHANGE
 * @eventType ext.data.proxy.events.DataProxy_metaEvent.META_CHANGE
 */
[Event(name='onMetaChange', type='ext.data.proxy.events.DataProxy_metaEvent')]
/**
 * Proxies are used by <i>Stores</i> (→<code>ext.data.Store</code>) to handle the loading and saving of
 * →<code>ext.data.Model</code> data. Usually developers will not need to create or interact
 * with proxies directly.
 * <p><b>Types of Proxy</b></p>
 * <p>There are two main types of Proxy - →<code>ext.data.proxy.ClientProxy</code> and
 * →<code>ext.data.proxy.ServerProxy</code>. The Client proxies save their data locally and include
 * the following subclasses:</p>
 * <ul>
 * <li>→<code>ext.data.proxy.LocalStorageProxy</code> - saves its data to localStorage
 * if the browser supports it</li>
 * <li>→<code>ext.data.proxy.SessionStorageProxy</code> - saves its data to sessionStorage
 * if the browsers supports it</li>
 * <li>→<code>ext.data.proxy.MemoryProxy</code> - holds data in memory only, any data is lost
 * when the page is refreshed</li>
 * </ul>
 * <p>The Server proxies save their data by sending requests to some remote server. These proxies
 * include:</p>
 * <ul>
 * <li>→<code>ext.data.proxy.AjaxProxy</code> - sends requests to a server on the same domain</li>
 * <li>→<code>ext.data.proxy.JsonPProxy</code> - uses JSON-P to send requests to a server on a different
 * domain</li>
 * <li>→<code>ext.data.proxy.RestProxy</code> - uses RESTful HTTP methods (GET/PUT/POST/DELETE)
 * to communicate with server</li>
 * <li>→<code>ext.data.proxy.DirectProxy</code> - uses →<code>ext.direct.DirectManager</code> to send requests</li>
 * </ul>
 * <p>Proxies operate on the principle that all operations performed are either Create, Read, Update
 * or Delete. These four operations are mapped to the methods →<code>create()</code>,
 * →<code>read()</code>, →<code>update()</code> and →<code>erase()</code> respectively. Each Proxy
 * subclass implements these functions.</p>
 * <p>The CRUD methods each expect an →<code>ext.data.operation.Operation</code> object as the only
 * argument. The Operation encapsulates information about the action the Store wishes to perform,
 * the <i>model</i> (→<code>ext.data.Model</code>) instances that are to be modified, etc. See the
 * →<code>ext.data.operation.Operation</code> documentation for more details. Each CRUD
 * method also accepts a callback function to be called asynchronously on completion.</p>
 * <p>Proxies also support batching of Operations via a <i>batch</i> (→<code>ext.data.Batch</code>) object, invoked
 * by the →<code>batch()</code>
 * method.</p>
 * @see ext.data.Store
 * @see ext.data.Model
 * @see ext.data.proxy.ClientProxy
 * @see ext.data.proxy.ServerProxy
 * @see ext.data.proxy.LocalStorageProxy
 * @see ext.data.proxy.SessionStorageProxy
 * @see ext.data.proxy.MemoryProxy
 * @see ext.data.proxy.AjaxProxy
 * @see ext.data.proxy.JsonPProxy
 * @see ext.data.proxy.RestProxy
 * @see ext.data.proxy.DirectProxy
 * @see ext.direct.#DirectManager ext.direct.DirectManager
 * @see #create()
 * @see #read()
 * @see #update()
 * @see #erase()
 * @see ext.data.operation.Operation
 * @see ext.data.Batch
 * @see #batch()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html Original Ext JS documentation of 'Ext.data.proxy.Proxy'
 */
public class DataProxy extends Observable implements IFactoryable {
  /**
   * Creates the Proxy
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DataProxy(config:DataProxy = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * True to batch actions of a particular type when synchronizing the store. Defaults to
   * <code>true</code>.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#cfg-batchActions Original Ext JS documentation of 'batchActions'
   * @see #getBatchActions()
   * @see #setBatchActions()
   */
  public native function get batchActions():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set batchActions(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Comma-separated ordering 'create', 'update' and 'destroy' actions when batching.
   * Override this to set a different order for the batched CRUD actions to be executed in.
   * Defaults to 'create,update,destroy'.
   * @default 'create,update,destroy'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#cfg-batchOrder Original Ext JS documentation of 'batchOrder'
   * @see #getBatchOrder()
   * @see #setBatchOrder()
   */
  public native function get batchOrder():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set batchOrder(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Proxy, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#property-isProxy Original Ext JS documentation of 'isProxy'
   */
  public native function get isProxy():Boolean;

  /**
   * @private
   */
  public native function set isProxy(value:Boolean):void;

  /**
   * Identifies the proxy as (a)synchronous.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#property-isSynchronous Original Ext JS documentation of 'isSynchronous'
   */
  public native function get isSynchronous():Boolean;

  /**
   * @private
   */
  public native function set isSynchronous(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the Model to tie to this Proxy. Can be either the string name of the Model,
   * or a reference to the Model constructor. Required.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#cfg-model Original Ext JS documentation of 'model'
   * @see #getModel()
   * @see #setModel()
   */
  public native function get model():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set model(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The Ext.data.reader.Reader to use to decode the server's response or data read
   * from client. This can either be a Reader instance, a config object or just a
   * valid Reader type name (e.g. 'json', 'xml').
   * @default {
   *     type: 'json'
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#cfg-reader Original Ext JS documentation of 'reader'
   * @see #getReader()
   * @see #setReader()
   */
  public native function get reader():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set reader(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The Ext.data.writer.Writer to use to encode any request sent to the server or
   * saved to client. This can either be a Writer instance, a config object or just
   * a valid Writer type name (e.g. 'json', 'xml').
   * @default {
   *     type: 'json'
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#cfg-writer Original Ext JS documentation of 'writer'
   * @see #getWriter()
   * @see #setWriter()
   */
  public native function get writer():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set writer(value:*):void;

  /**
   * Performs a batch of <i>Operations</i> (→<code>ext.data.operation.Operation</code>), in the order specified
   * by →<code>batchOrder</code>. Used internally by →<code>ext.data.Store</code>'s
   * →<code>ext.data.Store.sync()</code> method. Example usage:
   * <pre>
   * myProxy.batch({
   *     create : [myModel1, myModel2],
   *     update : [myModel3],
   *     destroy: [myModel4, myModel5]
   * });
   * </pre>
   * <p>Where the myModel&#42; above are →<code>ext.data.Model</code> instances - in this case 1 and 2
   * are new instances and have not been saved before, 3 has been saved previously but needs to be
   * updated, and 4 and 5 have already been saved but should now be destroyed.</p>
   * <p>Note that the previous version of this method took 2 arguments (operations and listeners).
   * While this is still supported for now, the current signature is now a single <code>options</code>
   * argument that can contain both operations and listeners, in addition to other options.
   * The multi-argument signature will likely be deprecated in a future release.</p>
   * @param options Object containing one or more properties supported by the batch
   * method:
   * <ul>
   * <li><code>operations:Object</code> (optional) —
   * Object containing the Model instances to act upon, keyed
   * by action name
   * </li>
   * <li><code>listeners:Object</code> (optional) —
   * Event listeners object passed straight through to the
   * Batch - see →<code>ext.data.Batch</code> for details
   * </li>
   * <li><code>batch</code> (optional) —
   * A →<code>ext.data.Batch</code> object (or batch
   * config to apply to the created batch). If unspecified a default batch will be auto-created.
   * </li>
   * <li><code>callback:Function</code> (optional) —
   * The function to be called upon completion of processing
   * the batch. The callback is called regardless of success or failure and is passed the
   * following parameters:
   * <ul>
   * <li><code>batch:ext.data.Batch</code> (optional) —
   * The <i>batch</i> (→<code>ext.data.Batch</code>) that was
   * processed, containing all operations in their current state after processing
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options argument that was originally passed
   * into batch
   * </li>
   * </ul>
   * </li>
   * <li><code>success:Function</code> (optional) —
   * The function to be called upon successful completion
   * of the batch. The success function is called only if no exceptions were reported in any
   * operations. If one or more exceptions occurred then the <code>failure</code> function will be called
   * instead. The success function is called with the following parameters:
   * <ul>
   * <li><code>batch:ext.data.Batch</code> (optional) —
   * The <i>batch</i> (→<code>ext.data.Batch</code>) that was
   * processed, containing all operations in their current state after processing
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options argument that was originally passed into
   * batch
   * </li>
   * </ul>
   * </li>
   * <li><code>failure:Function</code> (optional) —
   * The function to be called upon unsuccessful completion
   * of the batch. The failure function is called when one or more operations returns an
   * exception during processing (even if some operations were also successful). In this case you
   * can check the batch's →<code>ext.data.Batch.exceptions</code> array to see exactly
   * which operations had exceptions. The failure function is called with the following
   * parameters:
   * <ul>
   * <li><code>batch:ext.data.Batch</code> (optional) —
   * The <i>batch</i> (→<code>ext.data.Batch</code>) that was
   * processed, containing all operations in their current state after processing
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options argument that was originally passed into
   * batch
   * </li>
   * </ul>
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope in which to execute any callbacks (i.e. the <code>this</code>
   * object inside the callback, success and/or failure functions). Defaults to the proxy.
   * </li>
   * </ul>
   * @param listeners If <code>options</code> is the <code>operations</code>, this
   * parameter is the listeners. Instead of passing these two arguments, the proper form
   * is to pass them as:
   * <pre>
   *  batch({
   *      operations: ...
   *      listeners: ...
   *  });
   * </pre>
   * @return The newly created Batch
   * @see ext.data.operation.Operation
   * @see #batchOrder
   * @see ext.data.Store
   * @see ext.data.Store#sync()
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#method-batch Original Ext JS documentation of 'batch'
   * @see ext.data.Batch
   * @see ext.data.Batch#exceptions
   */
  public native function batch(options:Object, listeners:Object = null):Batch;

  /**
   * Performs the given create operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#method-create Original Ext JS documentation of 'create'
   */
  public native function create(operation:Operation):void;

  /**
   * Performs the given destroy operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#method-erase Original Ext JS documentation of 'erase'
   */
  public native function erase(operation:Operation):void;

  /**
   * Returns the value of <code>batchActions</code>.
   * @see #batchActions
   */
  public native function getBatchActions():Boolean;

  /**
   * Returns the value of <code>batchOrder</code>.
   * @see #batchOrder
   */
  public native function getBatchOrder():String;

  /**
   * Returns the value of <code>model</code>.
   * @see #model
   */
  public native function getModel():*;

  /**
   * Returns the value of <code>reader</code>.
   * @see #reader
   */
  public native function getReader():*;

  /**
   * Returns the value of <code>writer</code>.
   * @see #writer
   */
  public native function getWriter():*;

  /**
   * Performs the given read operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#method-read Original Ext JS documentation of 'read'
   */
  public native function read(operation:Operation):void;

  /**
   * Sets the value of <code>batchActions</code>.
   * @param batchActions The new value.
   * @see #batchActions
   */
  public native function setBatchActions(batchActions:Boolean):void;

  /**
   * Sets the value of <code>batchOrder</code>.
   * @param batchOrder The new value.
   * @see #batchOrder
   */
  public native function setBatchOrder(batchOrder:String):void;

  /**
   * Sets the value of <code>model</code>.
   * @param model The new value.
   * @see #model
   */
  public native function setModel(model:*):void;

  /**
   * Sets the value of <code>reader</code>.
   * @param reader The new value.
   * @see #reader
   */
  public native function setReader(reader:*):void;

  /**
   * Sets the value of <code>writer</code>.
   * @param writer The new value.
   * @see #writer
   */
  public native function setWriter(writer:*):void;

  /**
   * Performs the given update operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#method-update Original Ext JS documentation of 'update'
   */
  public native function update(operation:Operation):void;
}
}