package ext.data.proxy {
import ext.data.Request;
import ext.data.operation.Operation;

[Native("Ext.data.proxy.Server", require)]
/**
 * @see ext.data.proxy.events.ServerProxy_response_operationEvent.EXCEPTION
 * @eventType ext.data.proxy.events.ServerProxy_response_operationEvent.EXCEPTION
 */
[Event(name='onException', type='ext.data.proxy.events.ServerProxy_response_operationEvent')]
/**
 * ServerProxy is a superclass of →<code>ext.data.proxy.JsonPProxy</code> and
 * →<code>ext.data.proxy.AjaxProxy</code>, and would not usually be used directly.
 * @see ext.data.proxy.JsonPProxy
 * @see ext.data.proxy.AjaxProxy
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html Original Ext JS documentation of 'Ext.data.proxy.Server'
 */
public class ServerProxy extends DataProxy {
  /**
   * @param config @inheritDoc
   */
  public function ServerProxy(config:ServerProxy = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Specific urls to call on CRUD action methods "create", "read", "update" and "destroy".
   * Defaults to:
   * <pre>
   * api: {
   *     create  : undefined,
   *     read    : undefined,
   *     update  : undefined,
   *     destroy : undefined
   * }
   * </pre>
   * <p>The url is built based upon the action being executed [create|read|update|destroy] using
   * the commensurate →<code>api</code> property, or if undefined default to the configured
   * →<code>ext.data.Store</code>.→<code>ext.data.proxy.ServerProxy.url</code>.</p>
   * <p>For example:</p>
   * <pre>
   * api: {
   *     create  : '/controller/new',
   *     read    : '/controller/load',
   *     update  : '/controller/update',
   *     destroy : '/controller/destroy_action'
   * }
   * </pre>
   * <p>If the specific URL for a given CRUD action is undefined, the CRUD action request will
   * be directed to the configured →<code>ext.data.proxy.ServerProxy.url</code>.</p>
   * @default {
   *     create: undefined,
   *     read: undefined,
   *     update: undefined,
   *     destroy: undefined
   * }
   * @see #api
   * @see ext.data.Store
   * @see ext.data.proxy.ServerProxy#url
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-api Original Ext JS documentation of 'api'
   * @see #getApi()
   * @see #setApi()
   */
  public native function get api():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set api(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the cache param added to the url when using noCache. Defaults to "_dc".
   * @default "_dc"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-cacheString Original Ext JS documentation of 'cacheString'
   * @see #getCacheString()
   * @see #setCacheString()
   */
  public native function get cacheString():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set cacheString(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the direction parameter to send in a request. <b>This is only used when
   * simpleSortMode is set to true.</b>
   * <p>If this is set to the same value as the →<code>sortParam</code>, then the sort property name
   * <i>and</i> direction of each sorter is passed as a single, space separated parameter, looking
   * like a database <code>order by</code> specification.</p>
   * <p>So if there are multiple sorters, the single sort parameter will look like this:</p>
   * <pre>
   * ?sort=name%20ASC&amp;sort=age%20DESC
   * </pre>
   * @default "dir"
   * @see #sortParam
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-directionParam Original Ext JS documentation of 'directionParam'
   * @see #getDirectionParam()
   * @see #setDirectionParam()
   */
  public native function get directionParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set directionParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Extra parameters that will be included on every request. Individual requests with params
   * of the same name will override these params when they are in conflict.
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-extraParams Original Ext JS documentation of 'extraParams'
   * @see #getExtraParams()
   * @see #setExtraParams()
   */
  public native function get extraParams():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set extraParams(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the 'filter' parameter to send in a request. Defaults to 'filter'. Set this
   * to <code>''</code> if you don't want to send a filter parameter.
   * @default "filter"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-filterParam Original Ext JS documentation of 'filterParam'
   * @see #getFilterParam()
   * @see #setFilterParam()
   */
  public native function get filterParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set filterParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the direction parameter to send in a request. <b>This is only used when
   * simpleGroupMode is set to true.</b>
   * If this is set to the same value as the →<code>groupParam</code>, then the group property
   * name <i>and</i> direction of each grouper is passed as a single, space separated parameter,
   * looking like a database <code>group by</code> specification.
   * <p>So if there are multiple groupers, the single group parameter will look like this:</p>
   * <pre>
   * ?group=name%20ASC&amp;group=age%20DESC
   * </pre>
   * @default "groupDir"
   * @see #groupParam
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-groupDirectionParam Original Ext JS documentation of 'groupDirectionParam'
   * @see #getGroupDirectionParam()
   * @see #setGroupDirectionParam()
   */
  public native function get groupDirectionParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groupDirectionParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the 'group' parameter to send in a request. Defaults to 'group'. Set this to
   * <code>''</code> if you don't want to send a group parameter.
   * @default "group"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-groupParam Original Ext JS documentation of 'groupParam'
   * @see #getGroupParam()
   * @see #setGroupParam()
   */
  public native function get groupParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groupParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the parameter which carries the id of the entity being operated upon.
   * @default "id"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-idParam Original Ext JS documentation of 'idParam'
   * @see #getIdParam()
   * @see #setIdParam()
   */
  public native function get idParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set idParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the 'limit' parameter to send in a request. Defaults to 'limit'. Set this to
   * <code>''</code> if you don't want to send a limit parameter.
   * @default "limit"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-limitParam Original Ext JS documentation of 'limitParam'
   * @see #getLimitParam()
   * @see #setLimitParam()
   */
  public native function get limitParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set limitParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Disable caching by adding a unique parameter name to the request. Set to false to allow
   * caching. Defaults to true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-noCache Original Ext JS documentation of 'noCache'
   * @see #getNoCache()
   * @see #setNoCache()
   */
  public native function get noCache():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set noCache(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the 'page' parameter to send in a request. Defaults to 'page'. Set this to
   * <code>''</code> if you don't want to send a page parameter.
   * @default "page"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-pageParam Original Ext JS documentation of 'pageParam'
   * @see #getPageParam()
   * @see #setPageParam()
   */
  public native function get pageParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set pageParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Enabling simpleGroupMode in conjunction with remoteGroup will only send one group
   * property and a direction when a remote group is requested. The
   * →<code>groupDirectionParam</code> and →<code>groupParam</code> will be sent with the property name
   * and either 'ASC' or 'DESC'.
   * @default false
   * @see #groupDirectionParam
   * @see #groupParam
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-simpleGroupMode Original Ext JS documentation of 'simpleGroupMode'
   * @see #getSimpleGroupMode()
   * @see #setSimpleGroupMode()
   */
  public native function get simpleGroupMode():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set simpleGroupMode(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Enabling simpleSortMode in conjunction with remoteSort will send the sorted field names
   * in the parameter named by →<code>sortParam</code>, and the directions for each sorted field
   * in a parameter named by →<code>directionParam</code>.
   * <p>In the simplest case, with one Sorter, this will result in HTTP parameters like this:</p>
   * <pre>
   * ?sort=name&amp;dir=ASC
   * </pre>
   * <p>If there are multiple sorters, the parameters will be encoded like this:</p>
   * <pre>
   * ?sort=name&amp;sort=age&amp;dir=ASC&amp;dir=DESC
   * </pre>
   * @default false
   * @see #sortParam
   * @see #directionParam
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-simpleSortMode Original Ext JS documentation of 'simpleSortMode'
   * @see #getSimpleSortMode()
   * @see #setSimpleSortMode()
   */
  public native function get simpleSortMode():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set simpleSortMode(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the 'sort' parameter to send in a request. Defaults to 'sort'. Set this to
   * <code>''</code> if you don't want to send a sort parameter.
   * @default "sort"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-sortParam Original Ext JS documentation of 'sortParam'
   * @see #getSortParam()
   * @see #setSortParam()
   */
  public native function get sortParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sortParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the 'start' parameter to send in a request. Defaults to 'start'. Set this to
   * <code>''</code> if you don't want to send a start parameter.
   * @default "start"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-startParam Original Ext JS documentation of 'startParam'
   * @see #getStartParam()
   * @see #setStartParam()
   */
  public native function get startParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set startParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of milliseconds to wait for a response. Defaults to 30000 milliseconds
   * (30 seconds).
   * @default 30000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-timeout Original Ext JS documentation of 'timeout'
   * @see #getTimeout()
   * @see #setTimeout()
   */
  public native function get timeout():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The URL from which to request the data object.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#cfg-url Original Ext JS documentation of 'url'
   * @see #getUrl()
   * @see #setUrl()
   */
  public native function get url():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set url(value:String):void;

  /**
   * Optional callback function which can be used to clean up after a request has been completed.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param request The Request object
   * @param success True if the request was successful
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-afterRequest Original Ext JS documentation of 'afterRequest'
   */
  protected native function afterRequest(request:Request, success:Boolean):void;

  /**
   * Encode any values being sent to the server. Can be overridden in subclasses.
   * @param value An array of sorters/filters.
   * @return The encoded value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-applyEncoding Original Ext JS documentation of 'applyEncoding'
   */
  protected native function applyEncoding(value:Array):Object;

  /**
   * Creates an →<code>ext.data.Request</code> object from
   * →<code>ext.data.operation.Operation</code>.
   * <p>This gets called from doRequest methods in subclasses of Server proxy.</p>
   * @param operation The operation to execute
   * @return The request object
   * @see ext.data.Request
   * @see ext.data.operation.Operation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-buildRequest Original Ext JS documentation of 'buildRequest'
   */
  public native function buildRequest(operation:Operation):Request;

  /**
   * Generates a url based on a given Ext.data.Request object. By default, ServerProxy's buildUrl
   * will add the cache-buster param to the end of the url. Subclasses may need to perform
   * additional modifications to the url.
   * @param request The request object
   * @return The url
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-buildUrl Original Ext JS documentation of 'buildUrl'
   */
  public native function buildUrl(request:Request):String;

  /**
   * In ServerProxy subclasses, the →<code>create()</code>, →<code>read()</code>,
   * →<code>update()</code>, and →<code>erase()</code> methods all pass through to doRequest.
   * Each ServerProxy subclass must implement the doRequest method - see
   * →<code>ext.data.proxy.JsonPProxy</code> and →<code>ext.data.proxy.AjaxProxy</code> for examples. This method
   * carries the same signature as each of the methods that delegate to it.
   * @param operation The Ext.data.operation.Operation object
   * @param callback The callback function to call when the Operation has completed
   * @param scope The scope in which to execute the callback
   * @see #create()
   * @see #read()
   * @see #update()
   * @see #erase()
   * @see ext.data.proxy.JsonPProxy
   * @see ext.data.proxy.AjaxProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-doRequest Original Ext JS documentation of 'doRequest'
   */
  protected native function doRequest(operation:Operation, callback:Function, scope:Object):void;

  /**
   * Encodes the array of →<code>ext.util.Filter</code> objects into a string to be sent in the request
   * url. By default, this simply JSON-encodes the filter data
   * @param filters The array of →<code>ext.util.Filter</code> objects
   * @return The encoded filters
   * @see ext.util.Filter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-encodeFilters Original Ext JS documentation of 'encodeFilters'
   */
  public native function encodeFilters(filters:Array):String;

  /**
   * Encodes the array of →<code>ext.util.Sorter</code> objects into a string to be sent in the request
   * url. By default, this simply JSON-encodes the sorter data
   * @param sorters The array of →<code>ext.util.Sorter</code> objects
   * @param preventArray Prevents the items from being output as an array.
   * @default false
   * @return The encoded sorters
   * @see ext.util.Sorter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-encodeSorters Original Ext JS documentation of 'encodeSorters'
   */
  public native function encodeSorters(sorters:Array, preventArray:Boolean = false):String;

  /**
   * Returns the value of <code>api</code>.
   * @see #api
   */
  public native function getApi():Object;

  /**
   * Returns the value of <code>cacheString</code>.
   * @see #cacheString
   */
  public native function getCacheString():String;

  /**
   * Returns the value of <code>directionParam</code>.
   * @see #directionParam
   */
  public native function getDirectionParam():String;

  /**
   * Returns the value of <code>extraParams</code>.
   * @see #extraParams
   */
  public native function getExtraParams():Object;

  /**
   * Returns the value of <code>filterParam</code>.
   * @see #filterParam
   */
  public native function getFilterParam():String;

  /**
   * Returns the value of <code>groupDirectionParam</code>.
   * @see #groupDirectionParam
   */
  public native function getGroupDirectionParam():String;

  /**
   * Returns the value of <code>groupParam</code>.
   * @see #groupParam
   */
  public native function getGroupParam():String;

  /**
   * Returns the value of <code>idParam</code>.
   * @see #idParam
   */
  public native function getIdParam():String;

  /**
   * Returns the value of <code>limitParam</code>.
   * @see #limitParam
   */
  public native function getLimitParam():String;

  /**
   * Returns the value of <code>noCache</code>.
   * @see #noCache
   */
  public native function getNoCache():Boolean;

  /**
   * Returns the value of <code>pageParam</code>.
   * @see #pageParam
   */
  public native function getPageParam():String;

  /**
   * Returns the value of <code>simpleGroupMode</code>.
   * @see #simpleGroupMode
   */
  public native function getSimpleGroupMode():Boolean;

  /**
   * Returns the value of <code>simpleSortMode</code>.
   * @see #simpleSortMode
   */
  public native function getSimpleSortMode():Boolean;

  /**
   * Returns the value of <code>sortParam</code>.
   * @see #sortParam
   */
  public native function getSortParam():String;

  /**
   * Returns the value of <code>startParam</code>.
   * @see #startParam
   */
  public native function getStartParam():String;

  /**
   * Returns the value of <code>timeout</code>.
   * @see #timeout
   */
  public native function getTimeout():Number;

  /**
   * Returns the value of <code>url</code>.
   * @see #url
   */
  public native function getUrl():String;

  /**
   * Processes response, which may involve updating or committing records, each of which
   * will inform the owning stores and their interested views. Finally, we may perform
   * an additional layout if the data shape has changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-processResponse Original Ext JS documentation of 'processResponse'
   */
  protected native function processResponse(success:*, operation:*, request:*, response:*):void;

  /**
   * Sets the value of <code>api</code>.
   * @param api The new value.
   * @see #api
   */
  public native function setApi(api:Object):void;

  /**
   * Sets the value of <code>cacheString</code>.
   * @param cacheString The new value.
   * @see #cacheString
   */
  public native function setCacheString(cacheString:String):void;

  /**
   * Sets the value of <code>directionParam</code>.
   * @param directionParam The new value.
   * @see #directionParam
   */
  public native function setDirectionParam(directionParam:String):void;

  /**
   * Sets a value in the underlying →<code>extraParams</code>.
   * @param name The key for the new value
   * @param value The value
   * @see #extraParams
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Server.html#method-setExtraParam Original Ext JS documentation of 'setExtraParam'
   */
  public native function setExtraParam(name:String, value:Object):void;

  /**
   * Sets the value of <code>extraParams</code>.
   * @param extraParams The new value.
   * @see #extraParams
   */
  public native function setExtraParams(extraParams:Object):void;

  /**
   * Sets the value of <code>filterParam</code>.
   * @param filterParam The new value.
   * @see #filterParam
   */
  public native function setFilterParam(filterParam:String):void;

  /**
   * Sets the value of <code>groupDirectionParam</code>.
   * @param groupDirectionParam The new value.
   * @see #groupDirectionParam
   */
  public native function setGroupDirectionParam(groupDirectionParam:String):void;

  /**
   * Sets the value of <code>groupParam</code>.
   * @param groupParam The new value.
   * @see #groupParam
   */
  public native function setGroupParam(groupParam:String):void;

  /**
   * Sets the value of <code>idParam</code>.
   * @param idParam The new value.
   * @see #idParam
   */
  public native function setIdParam(idParam:String):void;

  /**
   * Sets the value of <code>limitParam</code>.
   * @param limitParam The new value.
   * @see #limitParam
   */
  public native function setLimitParam(limitParam:String):void;

  /**
   * Sets the value of <code>noCache</code>.
   * @param noCache The new value.
   * @see #noCache
   */
  public native function setNoCache(noCache:Boolean):void;

  /**
   * Sets the value of <code>pageParam</code>.
   * @param pageParam The new value.
   * @see #pageParam
   */
  public native function setPageParam(pageParam:String):void;

  /**
   * Sets the value of <code>simpleGroupMode</code>.
   * @param simpleGroupMode The new value.
   * @see #simpleGroupMode
   */
  public native function setSimpleGroupMode(simpleGroupMode:Boolean):void;

  /**
   * Sets the value of <code>simpleSortMode</code>.
   * @param simpleSortMode The new value.
   * @see #simpleSortMode
   */
  public native function setSimpleSortMode(simpleSortMode:Boolean):void;

  /**
   * Sets the value of <code>sortParam</code>.
   * @param sortParam The new value.
   * @see #sortParam
   */
  public native function setSortParam(sortParam:String):void;

  /**
   * Sets the value of <code>startParam</code>.
   * @param startParam The new value.
   * @see #startParam
   */
  public native function setStartParam(startParam:String):void;

  /**
   * Sets the value of <code>timeout</code>.
   * @param timeout The new value.
   * @see #timeout
   */
  public native function setTimeout(timeout:Number):void;

  /**
   * Sets the value of <code>url</code>.
   * @param url The new value.
   * @see #url
   */
  public native function setUrl(url:String):void;
}
}