package ext.data.proxy {

[Native("Ext.data.proxy.SessionStorage", require)]
/**
 * Proxy which uses HTML5 session storage as its data storage/retrieval mechanism. If this proxy
 * is used in a browser where session storage is not supported, the constructor will throw an error.
 * A session storage proxy requires a unique ID which is used as a key in which all record data
 * are stored in the session storage object.
 * <p>It's important to supply this unique ID as it cannot be reliably determined otherwise. If no id
 * is provided but the attached store has a storeId, the storeId will be used. If neither option
 * is presented the proxy will throw an error.</p>
 * <p>Proxies are almost always used with a <i>store</i> (→<code>ext.data.Store</code>):</p>
 * <pre>
 * new Ext.data.Store({
 *     proxy: {
 *         type: 'sessionstorage',
 *         id: 'myProxyKey'
 *     }
 * });
 * </pre>
 * <p>Alternatively you can instantiate the Proxy directly:</p>
 * <pre>
 * new Ext.data.proxy.SessionStorage({
 *     id: 'myOtherProxyKey'
 * });
 * </pre>
 * <p>Note that session storage is different to local storage (see
 * →<code>ext.data.proxy.LocalStorageProxy</code>) - if a browser session is ended (e.g. by closing
 * the browser) then all data in a SessionStorageProxy are lost. Browser restarts
 * don't affect the →<code>ext.data.proxy.LocalStorageProxy</code> - the data are preserved.</p>
 * @see ext.data.Store
 * @see ext.data.proxy.LocalStorageProxy
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.SessionStorage.html Original Ext JS documentation of 'Ext.data.proxy.SessionStorage'
 */
public class SessionStorageProxy extends WebStorageProxy {
  /**
   * @param config @inheritDoc
   */
  public function SessionStorageProxy(config:SessionStorageProxy = null) {
    super();
  }
}
}