package ext.data.proxy {
import ext.data.Model;
import ext.data.operation.Operation;

[Native("Ext.data.proxy.WebStorage", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>WebStorageProxy is simply a superclass for the →<code>ext.data.proxy.LocalStorageProxy</code>
 * and →<code>ext.data.proxy.SessionStorageProxy</code> proxies. It uses the new HTML5
 * key/value client-side storage objects to save <i>model instances</i> (→<code>ext.data.Model</code>) for
 * offline use.</p>
 * @see ext.data.proxy.LocalStorageProxy
 * @see ext.data.proxy.SessionStorageProxy
 * @see ext.data.Model
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html Original Ext JS documentation of 'Ext.data.proxy.WebStorage'
 */
public class WebStorageProxy extends ClientProxy {
  /**
   * Creates the proxy, throws an error if local storage is not supported in the current browser.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function WebStorageProxy(config:WebStorageProxy = null) {
    super();
  }

  /**
   * Cached map of records already retrieved by this Proxy. Ensures that the same instance is
   * always retrieved.
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#property-cache Original Ext JS documentation of 'cache'
   */
  public native function get cache():Object;

  /**
   * @private
   */
  public native function set cache(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The unique ID used as the key in which all record data are stored in the local
   * storage object.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   * @see #setId()
   */
  public native function get id():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set id(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Not used by web storage proxy.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#cfg-reader Original Ext JS documentation of 'reader'
   * @see #getReader()
   * @see #setReader()
   */
  override public native function get reader():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set reader(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Not used by web storage proxy.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#cfg-writer Original Ext JS documentation of 'writer'
   * @see #getWriter()
   * @see #setWriter()
   */
  override public native function get writer():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set writer(value:*):void;

  /**
   * Destroys all records stored in the proxy and removes all keys and values used to support
   * the proxy from the storage object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#method-clear Original Ext JS documentation of 'clear'
   */
  override public native function clear():void;

  /**
   * Performs the given create operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#method-create Original Ext JS documentation of 'create'
   */
  override public native function create(operation:Operation):void;

  /**
   * Performs the given destroy operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#method-erase Original Ext JS documentation of 'erase'
   */
  override public native function erase(operation:Operation):void;

  /**
   * Returns the value of <code>id</code>.
   * @see #id
   */
  override public native function getId():String;

  /**
   * Returns the value of <code>reader</code>.
   * @see #reader
   */
  override public native function getReader():*;

  /**
   * Returns the value of <code>writer</code>.
   * @see #writer
   */
  override public native function getWriter():*;

  /**
   * Performs the given read operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#method-read Original Ext JS documentation of 'read'
   */
  override public native function read(operation:Operation):void;

  /**
   * Sets the value of <code>id</code>.
   * @param id The new value.
   * @see #id
   */
  override public native function setId(id:String):void;

  /**
   * Sets the value of <code>reader</code>.
   * @param reader The new value.
   * @see #reader
   */
  override public native function setReader(reader:*):void;

  /**
   * Saves the given record in the Proxy.
   * @param record The model instance
   * @param id The id to save the record under (defaults to the value of the
   * record's getId() function)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#method-setRecord Original Ext JS documentation of 'setRecord'
   */
  public native function setRecord(record:Model, id:String = null):void;

  /**
   * Sets the value of <code>writer</code>.
   * @param writer The new value.
   * @see #writer
   */
  override public native function setWriter(writer:*):void;

  /**
   * Performs the given update operation.
   * @param operation The Operation to perform
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.WebStorage.html#method-update Original Ext JS documentation of 'update'
   */
  override public native function update(operation:Operation):void;
}
}