package ext.data.proxy.events {
import ext.data.proxy.DataProxy;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.data.proxy.events.DataProxy_metaEvent")]
public class DataProxy_metaEvent extends FlExtEvent {
  /**
   * Fires when this proxy's reader provides new metadata. Metadata usually consists
   * of new field definitions, but can include any configuration data required by an
   * application, and can be processed as needed in the event handler.
   * This event is currently only fired for JsonReaders. Note that this event is also
   * propagated by →<code>ext.data.Store</code>, which is typically where it would be handled.
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.proxy.Proxy.html#event-metachange Original Ext JS documentation of 'metachange'
   * @see ext.data.proxy.DataProxy
   * @eventType onMetaChange
   */
  public static const META_CHANGE:String = "onMetaChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "meta", "eOpts"];

  public function DataProxy_metaEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The JSON metadata
   */
  public native function get meta():Object;

  public native function get source():DataProxy;
}
}