package ext.data.reader {

[Native("Ext.data.reader.Array", require)]
/**
 * Data reader class to create an Array of →<code>ext.data.Model</code> objects from an Array.
 * Each element of that Array represents a row of data fields. The
 * fields are pulled into a Record object using as a subscript, the <code>mapping</code> property
 * of the field definition if it exists, or the field's ordinal position in the definition.
 * <p><b><i>Example code:</i></b></p>
 * <pre>
 *  Employee = Ext.define('Employee', {
 *      extend: 'Ext.data.Model',
 *      fields: [
 *          'id',
 *          // "mapping" only needed if an "id" field is present which
 *          // precludes using the ordinal position as the index.
 *          { name: 'name', mapping: 1 },
 *          { name: 'occupation', mapping: 2 }
 *      ]
 *  });
 *
 *   var myReader = new Ext.data.reader.Array({
 *        model: 'Employee'
 *   }, Employee);
 * </pre>
 * <p>This would consume an Array like this:</p>
 * <pre>
 *  [ [1, 'Bill', 'Gardener'], [2, 'Ben', 'Horticulturalist'] ]
 * </pre>
 * @see ext.data.Model
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.reader.Array.html Original Ext JS documentation of 'Ext.data.reader.Array'
 */
public class ArrayReader extends JsonReader {
  /**
   * @param meta Metadata configuration options.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.reader.Array.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function ArrayReader(meta:Object) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.reader.Array.html#cfg-preserveRawData Original Ext JS documentation of 'preserveRawData'
   * @see #getPreserveRawData()
   * @see #setPreserveRawData()
   */
  override public native function get preserveRawData():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set preserveRawData(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Name of the property from which to retrieve the <code>success</code> attribute, the value of which
   * indicates whether a given request succeeded or failed (typically a boolean or
   * 'true'|'false'). See
   * →<code>ext.data.proxy.ServerProxy</code>.→<code>ext.data.proxy.ServerProxy.event:onException</code> for
   * additional information.
   * @default undefined
   * @see ext.data.proxy.ServerProxy
   * @see ext.data.proxy.ServerProxy#event:onException
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.reader.Array.html#cfg-successProperty Original Ext JS documentation of 'successProperty'
   * @see #getSuccessProperty()
   * @see #setSuccessProperty()
   */
  override public native function get successProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set successProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Name of the property from which to retrieve the total number of records in the dataset.
   * This is only needed if the whole dataset is not passed in one go, but is being paged from
   * the remote server.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.reader.Array.html#cfg-totalProperty Original Ext JS documentation of 'totalProperty'
   * @see #getTotalProperty()
   * @see #setTotalProperty()
   */
  override public native function get totalProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set totalProperty(value:String):void;

  /**
   * Returns the value of <code>preserveRawData</code>.
   * @see #preserveRawData
   */
  override public native function getPreserveRawData():Boolean;

  /**
   * Returns the value of <code>successProperty</code>.
   * @see #successProperty
   */
  override public native function getSuccessProperty():String;

  /**
   * Returns the value of <code>totalProperty</code>.
   * @see #totalProperty
   */
  override public native function getTotalProperty():String;

  /**
   * Sets the value of <code>preserveRawData</code>.
   * @param preserveRawData The new value.
   * @see #preserveRawData
   */
  override public native function setPreserveRawData(preserveRawData:Boolean):void;

  /**
   * Sets the value of <code>successProperty</code>.
   * @param successProperty The new value.
   * @see #successProperty
   */
  override public native function setSuccessProperty(successProperty:String):void;

  /**
   * Sets the value of <code>totalProperty</code>.
   * @param totalProperty The new value.
   * @see #totalProperty
   */
  override public native function setTotalProperty(totalProperty:String):void;
}
}