package ext.data.request {

[Native("Ext.data.request.Ajax", require)]
/**
 * This class manages a pending Ajax request. Instances of this type are created by the
 * <code>→ext.data.Connection.request()</code> method.
 * @see ext.data.Connection#request()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.request.Ajax.html Original Ext JS documentation of 'Ext.data.request.Ajax'
 */
public class AjaxRequest extends BaseRequest {
  /**
   * @param config @inheritDoc
   */
  public function AjaxRequest(config:AjaxRequest = null) {
    super();
  }

  /**
   * Aborts an active request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.request.Ajax.html#method-abort Original Ext JS documentation of 'abort'
   */
  public native function abort(force:*):void;

  /**
   * Cleans up any left over information from the request
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.request.Ajax.html#method-cleanup Original Ext JS documentation of 'cleanup'
   */
  public native function cleanup():void;
}
}