package ext.data.request {
import ext.Base;
import ext.IPromise;
import ext.mixin.IFactoryable;

[Native("Ext.data.request.Base", require)]
/**
 * This class manages a pending Ajax request. Instances of this type are created by the
 * <code>→ext.data.Connection.request()</code> method.
 * @see ext.data.Connection#request()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.request.Base.html Original Ext JS documentation of 'Ext.data.request.Base'
 */
public class BaseRequest extends Base implements IFactoryable, IPromise {
  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * Determines whether this request is in progress.
   * @return <code>true</code> if this request is in progress, <code>false</code> if complete.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.request.Base.html#method-isLoading Original Ext JS documentation of 'isLoading'
   */
  public native function isLoading():Boolean;

  /**
   * Start the request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.request.Base.html#method-start Original Ext JS documentation of 'start'
   */
  public native function start():void;

  /**
   * Returns a new promise resolving to the value of the called method.
   * @param success Called when the Promise is fulfilled.
   * @param failure Called when the Promise is rejected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.request.Base.html#method-then Original Ext JS documentation of 'then'
   */
  public native function then(success:Function = null, failure:Function = null, onProgress:Function = null):IPromise;
}
}