package ext.data.schema {
import ext.Base;
import ext.ExtClass;
import ext.data.field.DataField;

[Native("Ext.data.schema.Association", require)]
/**
 * <b>This class is never created directly. It should be constructed through associations
 * in <code>→ext.data.Model</code>.</b>
 * <p>Associations enable you to express relationships between different <i>Models</i> (→<code>ext.data.Model</code>).
 * Consider an ecommerce system where Users can place Orders - there is a one to many relationship
 * between these Models, one user can have many orders (including 0 orders). Here is what a sample
 * implementation of this association could look like. This example will be referred to in the
 * following sections.</p>
 * <pre>
 * Ext.define('User', {
 *     extend: 'Ext.data.Model',
 *     fields: [{
 *         name: 'id',
 *         type: 'int'
 *     }, 'name']
 * });
 *
 * Ext.define('Order', {
 *     extend: 'Ext.data.Model',
 *     fields: [{
 *         name: 'id',
 *         type: 'int'
 *     }, {
 *         name: 'userId',
 *         type: 'int',
 *         reference: 'User'
 *     }]
 * });
 * </pre>
 * <p><b>Association Types</b></p>
 * <p>Assocations can describe relationships in 3 ways:</p>
 * <p><b><i>Many To One</i></b></p>
 * <p>A single entity (<code>A</code>) has a relationship with many (<code>B</code>) entities. An example of this is
 * an ecommerce system <code>User</code> can have many <code>Order</code> entities.</p>
 * <p>This can be defined using <code>→ext.data.schema.ManyToOne</code> for keyed associations, or
 * <code>→ext.data.schema.HasMany</code> for keyless associations.</p>
 * <p><b><i>One To One</i></b></p>
 * <p>A less common form of Many To One, a single entity (<code>A</code>) has a relationship with at most 1 entity
 * (<code>B</code>). This is often used when partitioning data. For example a <code>User</code> may have a single
 * <code>UserInfo</code> object that stores extra metadata about the user.</p>
 * <p>This can be defined using <code>→ext.data.schema.OneToOne</code> for keyed associations, or
 * <code>→ext.data.schema.HasOne</code> for keyless associations.</p>
 * <p><b><i>Many To Many</i></b></p>
 * <p>An entity (<code>A</code>) may have a have a relationship with many (<code>B</code>) entities. That (<code>B</code>) entity may
 * also have a relationship with many <code>A</code> entities. For example a single <code>Student</code> can have many
 * <code>Subject</code> entities and a single <code>Subject</code> can have many <code>Student</code> entities.</p>
 * <p>This can be defined using <code>→ext.data.schema.ManyToMany</code>. Many To Many relationships are read-only
 * unless used with a <code>→ext.data.Session</code>.</p>
 * <p><b>Keyed vs Keyless Associations</b></p>
 * <p>Associations can be declared in 2 ways, which are outlined below.</p>
 * <p><b><i>Keyed associations</i></b></p>
 * <p>A keyed association relies on a field in the model matching the id of another model. Membership
 * is driven by the key. This is the type of relationship that is typically used in a relational
 * database. This is declared using the ||reference|| configuration on a model field. An example
 * of this can be seen above for <code>User/Order</code>.</p>
 * <p><b>Keyless associations</b></p>
 * <p>A keyless association relies on data hierarchy to determine membership. Items are members because
 * they are contained by another entity. This type of relationship is common with NoSQL databases.
 * formats. A simple example definition using <code>User/Order</code>:</p>
 * <pre>
 * Ext.define('User', {
 *     extend: 'Ext.data.Model',
 *     fields: [{
 *         name: 'id',
 *         type: 'int'
 *     }, 'name'],
 *     hasMany: 'Order'
 * });
 *
 * Ext.define('Order', {
 *     extend: 'Ext.data.Model',
 *     fields: [{
 *         name: 'id',
 *         type: 'int'
 *     }]
 * });
 * </pre>
 * <p><b>Advantages of Associations</b></p>
 * <p>Assocations make it easier to work with Models that share a connection. Some of the main
 * functionality includes:</p>
 * <p><b><i>Generated Accessors/Setters</i></b></p>
 * <p>Associated models will automatically generate named methods that allow for accessing the
 * associated data. The names for these are created using a →<code>ext.data.schema.Schema</code>,
 * to provide a consistent and predictable naming structure.</p>
 * <p>Using the example code above, there will be 3 generated methods:</p>
 * <ul>
 * <li><code>User</code> will have an <code>orders()</code> function that returns a <code>→ext.data.Store</code> of<code>Orders</code>.</li>
 * <li><code>Order</code> will have a <code>getUser</code> method which will return a <code>User</code> Model.</li>
 * <li><code>Order</code> will have a <code>setUser</code> method that will accept a <code>User</code> model or a key value.</li>
 * </ul>
 * <p><b><i>Nested Loading</i></b></p>
 * <p>Nested loading is the ability to load hierarchical associated data from a remote source within
 * a single request. In the following example, each <code>User</code> in the <code>users</code> store has an <code>orders</code>
 * store. Each <code>orders</code> store is populated with <code>Order</code> models read from the request. Each <code>Order</code>
 * model also has a reference back to the appropriate <code>User</code>.</p>
 * <pre>
 * // Sample JSON data returned by /Users
 * [{
 *     "id": 1,
 *     "name": "User Foo",
 *     "orders": [{
 *         "id": 101,
 *         "userId": 1
 *     }, {
 *         "id": 102,
 *         "userId": 1
 *     }, {
 *         "id": 103,
 *         "userId": 1
 *     }]
 * }, {
 *     "id": 2,
 *     "name": "User Bar",
 *     "orders": [{
 *         "id": 201,
 *         "userId": 2
 *     }, {
 *         "id": 202,
 *         "userId": 2
 *     }]
 * }]
 *
 * // Application code
 * var users = new Ext.data.Store({
 *     model: 'User',
 *     proxy: {
 *         type: 'ajax',
 *         url: '/Users'
 *     }
 * });
 * users.load(function() {
 *     var user1 = users.first(),
 *         user2 = users.last(),
 *         orders1 = user1.orders(),
 *         orders2 = user2.orders();
 *
 *     // 3 orders, same reference back to user1
 *     console.log(orders1.getCount(), orders1.first().getUser() === user1);
 *     // 2 orders, same reference back to user2
 *     console.log(orders2.getCount(), orders2.first().getUser() === user2);
 * });
 * </pre>
 * <p><b><i>Binding</i></b></p>
 * <p>Data binding using <i>ViewModels</i> (→<code>ext.app.ViewModel</code>) have functionality to be able
 * to recognize associated data as part of a bind statement. For example:</p>
 * <ul>
 * <li><code>{user.orders}</code> binds to the orders store for a user.</li>
 * <li><code>{order.user.name}</code> binds to the name of the user taken from the order.</li>
 * </ul>
 * <p><b>Association Concepts</b></p>
 * <p><b><i>Roles</i></b></p>
 * <p>The role is used to determine generated names for an association. By default, the role is
 * generated from either the field name (in a keyed association) or the model name. This naming
 * follows a pattern defined by the <code>→ext.data.schema.Namer</code>. To change a specific instance,
 * an explicit role can be specified:</p>
 * <pre>
 * Ext.define('Thread', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'title']
 * });
 *
 * Ext.define('Post', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'content', {
 *         name: 'threadId',
 *         reference: {
 *             type: 'Thread',
 *             role: 'discussion',
 *             inverse: 'comments'
 *
 *         }
 *     }]
 * });
 * </pre>
 * <p>In the above example, the <code>Thread</code> will be decorated with a <code>comments</code> method that returns
 * the store. The <code>Post</code> will be decorated with <code>getDiscussion/setDiscussion</code> methods.</p>
 * <p><b><i>Generated Methods</i></b></p>
 * <p>Associations generate methods to allow reading and manipulation on associated data.</p>
 * <p>On records that have a "to many" relationship, a single methods that returns a <code>→ext.data.Store</code>
 * is created. See →<code>storeGetter()</code>. On records that have a "to one" relationship, 2 methods
 * are generated, a <i>getter</i> (→<code>recordGetter()</code>) and a <i>setter</i> (→<code>recordSetter()</code>).</p>
 * <p><b><i>Reflexive</i></b></p>
 * <p>Associations are reflexive. By declaring one "side" of the relationship, the other is
 * automatically setup. In the example below, there is no code in the <code>Thread</code> entity regarding
 * the association, however by virtue of the declaration in post, <code>Thread</code> is decorated with the
 * appropriate infrastructure to participate in the association.</p>
 * <pre>
 * Ext.define('Thread', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'title']
 * });
 *
 * Ext.define('Post', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'content', {
 *         name: 'threadId',
 *         reference: 'Thread'
 *     }]
 * });
 * </pre>
 * <p><b><i>Naming</i></b></p>
 * <p>Referring to model names in associations depends on their →<code>ext.data.Model.entityName</code>. See
 * the "Relative Naming" section in the <code>→ext.data.schema.Schema</code> documentation.</p>
 * @see ext.data.Model
 * @see ext.data.schema.ManyToOne
 * @see ext.data.schema.HasMany
 * @see ext.data.schema.OneToOne
 * @see ext.data.schema.HasOne
 * @see ext.data.schema.ManyToMany
 * @see ext.data.Session
 * @see ext.data.schema.Schema
 * @see ext.data.Store
 * @see ext.app.ViewModel
 * @see ext.data.schema.Namer
 * @see ext.data.Model#entityName
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html Original Ext JS documentation of 'Ext.data.schema.Association'
 */
public class Association extends Base {
  /**
   * @param config @inheritDoc
   */
  public function Association(config:Association = null) {
    super();
  }

  [ExtConfig]
  /**
   * The name of the property in the data to read the association from. Defaults to the
   * name of the associated model.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#cfg-associationKey Original Ext JS documentation of 'associationKey'
   */
  public native function get associationKey():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set associationKey(value:String):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#property-definedBy Original Ext JS documentation of 'definedBy'
   */
  public native function get definedBy():ExtClass;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#property-field Original Ext JS documentation of 'field'
   */
  public native function get field():DataField;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#property-left Original Ext JS documentation of 'left'
   */
  public native function get left():Base;

  [ExtConfig]
  /**
   * The name of this association.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#cfg-name Original Ext JS documentation of 'name'
   */
  public native function get name():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set name(value:String):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#property-nullable Original Ext JS documentation of 'nullable'
   */
  public native function get nullable():Boolean;

  /**
   * Points at either <code>left</code> or <code>right</code> objects if one is the owning party in this
   * association or is <code>null</code> if there is no owner.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#property-owner Original Ext JS documentation of 'owner'
   */
  public native function get owner():Object;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#property-right Original Ext JS documentation of 'right'
   */
  public native function get right():Base;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Association.html#property-schema Original Ext JS documentation of 'schema'
   */
  public native function get schema():Schema;
}
}