package ext.data.schema {

[Native("Ext.data.schema.ManyToOne", require)]
/**
 * <b>This class is never created directly. It should be constructed through associations
 * in <code>→ext.data.Model</code>.</b>
 * <p>Declares a relationship between a single entity type and multiple related entities.
 * The relationship can be declared as a keyed or keyless relationship.</p>
 * <pre>
 * // Keyed
 * Ext.define('Customer', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'name']
 * });
 *
 * Ext.define('Ticket', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'title', {
 *         name: 'customerId',
 *         reference: 'Customer'
 *     }]
 * });
 *
 * // Keyless
 * Ext.define('Customer', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'name'],
 *     hasMany: 'Ticket'
 * });
 *
 * Ext.define('Ticket', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'title']
 * });
 *
 * // Generated methods
 * var customer = new Customer();
 * customer.tickets();
 *
 * var ticket = new Ticket();
 * ticket.getCustomer();
 * ticket.setCustomer();
 * </pre>
 * <p>By declaring a keyed relationship, extra functionality is gained that maintains
 * the key field in the model as changes are made to the association.</p>
 * <p>For available configuration options, see →<code>ext.data.schema.Reference</code>.
 * The "one" record type will have a generated →<code>ext.data.schema.Association.storeGetter()</code>.
 * The "many" record type will have a <i>getter</i> (→<code>ext.data.schema.Association.recordGetter()</code>)
 * and <i>setter</i> (→<code>ext.data.schema.Association.recordSetter()</code>).</p>
 * @see ext.data.Model
 * @see ext.data.schema.Reference
 * @see ext.data.schema.Association#storeGetter()
 * @see ext.data.schema.Association#recordGetter()
 * @see ext.data.schema.Association#recordSetter()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.ManyToOne.html Original Ext JS documentation of 'Ext.data.schema.ManyToOne'
 */
public class ManyToOne extends Association {
  /**
   * @inheritDoc
   */
  public function ManyToOne(config:Association = null) {
    super();
  }
}
}