package ext.data.schema {
import ext.Base;
import ext.mixin.IFactoryable;

[Native("Ext.data.schema.Namer", require)]
/**
 * This class provides name derivation methods for use by a <code>Schema</code>.
 * <p><b>Caching</b></p>
 * <p>Because most name derivations are only textual manipulations of input strings, the
 * results can be cached. This is handled by the <code>apply</code> method by giving it the name of
 * the method to call. For example:</p>
 * <pre>
 *  var str = namer.capitalize('foo'); //  = "Foo"
 *
 *  var str = namer.apply('capitalize', 'foo');
 * </pre>
 * <p>The return value of the second call (using <code>apply</code>) is the same as the first, however,
 * the results of <code>capitalize</code> are cached. This allows repeated calls to <code>apply</code> given the
 * same operation and string to avoid the extra string manipulation.</p>
 * <p><b>Usage</b></p>
 * <p>This class is not intended to be created by application code. It is created by <code>Schema</code>
 * instances as directed by the <code>namer</code> config. Application code can derive from this
 * class and set the <code>namer</code> config to customize naming conventions used by the <code>Schema</code>.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Namer.html Original Ext JS documentation of 'Ext.data.schema.Namer'
 */
public class Namer extends Base implements IFactoryable {
  /**
   * @param config @inheritDoc
   */
  public function Namer(config:Namer = null) {
    super();
  }

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * Given the name of a foreign key field, return the role of the related entity. For
   * example, fields like "fooId" or "foo_id" this implementation returns "foo".
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Namer.html#method-fieldRole Original Ext JS documentation of 'fieldRole'
   */
  public native function fieldRole(name:*):void;

  /**
   * Returns the name for a one-to-many association given the left and right type and
   * the associating <code>role</code>.
   * <p>In many cases the <code>role</code> matches the target type. For example, an OrderItem might
   * have an "orderId" field which would have a <code>role</code> of "order". If this is a reference
   * to an Order entity then the association name will be "OrderOrderItems".</p>
   * <p>When the <code>role</code> does not match, it is included in the association name. For example,
   * consider a Ticket entity with a "creatorId" field that references a User entity.
   * The <code>role</code> of that field will (by default) be "creator". The returned association
   * name will be "UserCreatorTickets".</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Namer.html#method-manyToOne Original Ext JS documentation of 'manyToOne'
   */
  public native function manyToOne(leftType:*, leftRole:*, rightType:*, rightRole:*):void;
}
}