package ext.data.schema {

[Native("Ext.data.schema.OneToOne", require)]
/**
 * <b>This class is never created directly. It should be constructed through associations
 * in <code>→ext.data.Model</code>.</b>
 * <p>This is a specialized version of <code>→ext.data.schema.ManyToOne</code> that declares a relationship between
 * a single entity type and a single related entities. The relationship can be declared as a keyed
 * or keyless relationship.</p>
 * <pre>
 * // Keyed
 * Ext.define('User', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'name', {
 *         name: 'userInfoId',
 *         reference: {
 *             type: 'UserInfo',
 *             unique: true
 *         }
 *     }]
 * });
 *
 * Ext.define('UserInfo', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'secretKey']
 * });
 *
 * // Keyless
 * Ext.define('User', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'name'],
 *     hasOne: 'UserInfo'
 * });
 *
 * Ext.define('Ticket', {
 *     extend: 'Ext.data.Model',
 *     fields: ['id', 'secretKey']
 * });
 *
 * // Generated methods
 * var user = new User();
 * user.getUserInfo();
 * user.setUserInfo();
 *
 * var info = new UserInfo();
 * info.getUser();
 * info.setUser();
 *
 *
 * var ticket = new Ticket();
 * ticket.setCustomer(customer);
 * console.log(ticket.getCustomer()); // The customer object
 * </pre>
 * <p>By declaring a keyed relationship, extra functionality is gained that maintains
 * the key field in the model as changes are made to the association.</p>
 * <p>For available configuration options, see →<code>ext.data.schema.Reference</code>.
 * Each record type will have a <i>getter</i> (→<code>ext.data.schema.Association.recordGetter()</code>) and
 * <i>setter</i> (→<code>ext.data.schema.Association.recordSetter()</code>).</p>
 * @see ext.data.Model
 * @see ext.data.schema.ManyToOne
 * @see ext.data.schema.Reference
 * @see ext.data.schema.Association#recordGetter()
 * @see ext.data.schema.Association#recordSetter()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.OneToOne.html Original Ext JS documentation of 'Ext.data.schema.OneToOne'
 */
public class OneToOne extends Association {
  /**
   * @inheritDoc
   */
  public function OneToOne(config:Association = null) {
    super();
  }
}
}