package ext.data.schema {

[Native("Ext.data.schema.Reference", require)]
/**
 * <b>This is not a real JavaScript class and cannot be created. This is for documentation purposes
 * only.</b>
 * <p>This documentation is for:</p>
 * <ul>
 * <li><i>reference config</i> (→<code>ext.data.field.DataField.reference</code>)</li>
 * </ul>
 * <p>The <i>name</i> (→<code>ext.data.Model.entityName</code>) of the entity referenced by this field.
 * In most databases, this relationship is represented by a "foreign key". That is, a
 * value for such a field matches the value of the <i>id</i> (→<code>ext.data.Model.idProperty</code>)
 * for an entity of this type.</p>
 * <pre>
 *  Ext.define('MyApp.models.Organization', {
 *      extend: 'Ext.data.Model',
 *      ...
 *  });
 *
 *  Ext.define('MyApp.models.User', {
 *      extend: 'Ext.data.Model',
 *
 *      fields: [
 *          { name: 'organizationId', reference: 'Organization' }
 *      ],
 *      ...
 *  });
 * </pre>
 * <p>If the name of the generated <i>association</i> (→<code>ext.data.schema.Association</code>) or other aspects
 * need to be specified, the <code>reference</code> can be an object. The following usage shows
 * what would be generated by default given the above examples using the string form.</p>
 * <pre>
 *  Ext.define('MyApp.models.User', {
 *      extend: 'Ext.data.Model',
 *
 *      fields: [{
 *          name: 'organizationId',
 *          reference: {
 *              type: 'Organization',
 *              association: 'UsersByOrganization',
 *              role: 'organization',
 *              inverse: 'users'
 *          }
 *      }],
 *      ...
 *  });
 * </pre>
 * <p>Finally, a <code>reference</code> can also describe ownership between the entities. By default,
 * no ownership relationship is assumed. If, however, the User entities are owned by
 * their Organization, we could say this:</p>
 * <pre>
 *  Ext.define('MyApp.models.User', {
 *      extend: 'Ext.data.Model',
 *
 *      fields: [{
 *          name: 'organizationId',
 *          reference: {
 *              parent: 'Organization' // Organization is the parent of User
 *          }
 *      }],
 *      ...
 *  });
 * </pre>
 * @see ext.data.field.DataField#reference
 * @see ext.data.Model#entityName
 * @see ext.data.Model#idProperty
 * @see ext.data.schema.Association
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html Original Ext JS documentation of 'Ext.data.schema.Reference'
 */
public class Reference extends Object {
  [ExtConfig]
  /**
   * The name of the association. By default, the name of the association is the
   * capitalized <code>→inverse</code> plus "By" plus the capitalized <code>→role</code>.
   * @see #inverse
   * @see #role
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-association Original Ext JS documentation of 'association'
   */
  public native function get association():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set association(value:String):void;

  [ExtConfig]
  /**
   * Set this property instead of <code>reference.type</code> to indicate that the referenced entity
   * is an owned child of this entity. That is, the <code>reference</code> entity should be deleted
   * when this entity is deleted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-child Original Ext JS documentation of 'child'
   */
  public native function get child():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set child(value:String):void;

  [ExtConfig]
  /**
   * The name of the getter function. Typically this is generated
   * based on the →<code>role</code>.
   * @see #role
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-getterName Original Ext JS documentation of 'getterName'
   */
  public native function get getterName():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set getterName(value:String):void;

  [ExtConfig]
  /**
   * The name of the inverse role (of this entity with respect to the <code>reference</code>
   * entity). By default, this is the <i>pluralized</i> (→<code>ext.util.Inflector.pluralize()</code>)
   * name of this entity, unless this <code>reference</code> is <code>→unique</code>, in which case the default
   * name is the <i>singularized</i> (→<code>ext.util.Inflector.singularize()</code>) name of this entity.
   * <p>This config may also be an object containing a role, getter, or setter.</p>
   * @see ext.util.SInflector#pluralize() ext.util.Inflector.pluralize()
   * @see #unique
   * @see ext.util.SInflector#singularize() ext.util.Inflector.singularize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-inverse Original Ext JS documentation of 'inverse'
   */
  public native function get inverse():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inverse(value:*):void;

  [ExtConfig]
  /**
   * Set this property instead of <code>reference.type</code> to indicate that the referenced entity
   * is the owning parent of this entity. That is, this entity should be deleted when the
   * <code>reference</code> entity is deleted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-parent Original Ext JS documentation of 'parent'
   */
  public native function get parent():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set parent(value:String):void;

  [ExtConfig]
  /**
   * A custom →<code>ext.data.reader.DataReader</code> configuration for reading
   * nested data.
   * @see ext.data.reader.DataReader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-reader Original Ext JS documentation of 'reader'
   */
  public native function get reader():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reader(value:Object):void;

  [ExtConfig]
  /**
   * The name of the role played by the referenced entity. By default, this is the field
   * name (minus its "Id" suffix if present).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-role Original Ext JS documentation of 'role'
   */
  public native function get role():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set role(value:String):void;

  [ExtConfig]
  /**
   * The name of the setter function (if required). Typically this is
   * generated based on the →<code>role</code>.
   * @see #role
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-setterName Original Ext JS documentation of 'setterName'
   */
  public native function get setterName():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set setterName(value:String):void;

  [ExtConfig]
  /**
   * The type which this field references. This is the value set by the string form of
   * <code>reference</code>. If the referenced entity has an ownership relationship this field
   * should be omitted and <code>reference.parent</code> or <code>reference.child</code> should be specified
   * instead.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-type Original Ext JS documentation of 'type'
   */
  public native function get type():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set type(value:String):void;

  [ExtConfig]
  /**
   * <code>true</code> True for this reference to create a <code>→ext.data.schema.OneToOne</code>
   * relationship. If not specified, the default is <code>→ext.data.schema.ManyToOne</code>.
   * @see ext.data.schema.OneToOne
   * @see ext.data.schema.ManyToOne
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Reference.html#cfg-unique Original Ext JS documentation of 'unique'
   */
  public native function get unique():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set unique(value:Boolean):void;
}
}