package ext.data.schema {
import ext.Base;
import ext.ExtClass;
import ext.data.Model;
import ext.data.field.DataField;
import ext.mixin.IFactoryable;

[Native("Ext.data.schema.Schema", require)]
/**
 * A Schema is a collection of related <i>entities</i> (→<code>ext.data.Model</code>) and their respective
 * <i>associations</i> (→<code>ext.data.schema.Association</code>).
 * <p><b>Schema Instances</b></p>
 * <p>By default a single instance of this class is created which serves as the schema for all
 * entities that do not have an explicit <code>→ext.data.Model.schema</code> config
 * either specified or inherited. This is sufficient in most cases.</p>
 * <p>When an entity does specify a <code>→ext.data.Model.schema</code>, however, that
 * looks up (or creates) an instance for that entity class which is then inherited.</p>
 * <p><b>Important:</b> All related entities <i>must</i> belong to a single schema instance in order
 * to properly link up their associations.</p>
 * <p><b><i>Configuring Schemas</i></b></p>
 * <p>The best way to control the configuration of your <code>schema</code> is to define a base class for
 * all of your entities and use the <code>→ext.data.Model.schema</code> config like
 * this:</p>
 * <pre>
 *  Ext.define('MyApp.model.Base', {
 *      extend: 'Ext.data.Model',
 *
 *      // This configures the default schema because we don't assign an "id":
 *      schema: {
 *          // configs go here
 *      }
 *  });
 * </pre>
 * <p><b>Note:</b> Only one explicit configuration can be applied to the default schema. In most
 * applications this will not be an issue.</p>
 * <p>By using a base class for your entities you can ensure that the default schema is fully
 * configured before declaration of your classes proceeds. This is especially helpful if
 * you need to set the <code>→namespace</code> for your schema (see below).</p>
 * <p><b><i>Relative Naming</i></b></p>
 * <p>When describing associations between entities, it is desirable to use shorthand names
 * that do not contain the common namespace portion. This is called the <code>entityName</code> as
 * opposed to its class name. By default, the <code>entityName</code> is the full class name. However,
 * if a namespace is used, the common portion can be discarded and we can derive a shorter name.
 * In the following code, <code>"MyApp.model.Foo"</code> has an <code>entityName</code> of <code>"Foo"</code> and the schema has
 * a <code>→namespace</code> of "MyApp.model".</p>
 * <p>If you use deeper nesting for entities, you may need to set the <code>→namespace</code> config to
 * account for this. For example:</p>
 * <pre>
 *  Ext.define('MyApp.model.Base', {
 *      extend: 'Ext.data.Model',
 *
 *      schema: {
 *          namespace: 'MyApp.model'
 *      }
 *  });
 * </pre>
 * <p>Your derived classes now will generate proper default <code>entityName</code> values even if they
 * have further namespaces. For example, "MyApp.model.foo.Thing" will produce "foo.Thing"
 * as the <code>entityName</code> given the above as a base class.</p>
 * <p><b>Association Naming</b></p>
 * <p>There are various terms involved when describing associations. Perhaps the simplest
 * example that will clarify these terms is that of the common many-to-many association
 * of User and Group.</p>
 * <ul>
 * <li>
 * <p><code>entityName</code> - The names "User" and "Group" are the <code>entityName</code> values associated
 * with these two classes. These are derived from their full classnames (perhaps
 * something like "App.model.User" and "App.model.Group").</p>
 * </li>
 * <li>
 * <p><code>associationName</code> - When talking about associations, especially the many-to-many
 * variety, it is important to give them names. Associations are not owned by either of
 * the entities involved, so this name is similar to an <code>entityName</code>. In the case of
 * "User" and "Group", the default <code>associationName</code> would be "GroupUsers".</p>
 * </li>
 * <li>
 * <p><code>left</code> and <code>right</code> - Associations describe a relationship between two entities. To
 * talk about specific associations we would use the <code>entityName</code> of the parties (such
 * as "User" or "Group"). When discussing associations in the abstract, however, it is
 * very helpful to be able to talk about the entities in an association in a general way.
 * In the case of the "GroupUsers" association, "User" is said to be the <code>left</code> while
 * "Group" is said to be the <code>right</code>. In a many-to-many association the selection of
 * <code>left</code> and <code>right</code> is arbitrary. When a foreign-key is involved, the <code>left</code> entity
 * is the one containing the foreign-key.</p>
 * </li>
 * </ul>
 * <p><b><i>Custom Naming Conventions</i></b></p>
 * <p>One of the jobs the the <code>Schema</code> is to manage name generation (such as <code>entityName</code>).
 * This job is delegated to a class called the <code>→namer</code>. If you need to generate names in
 * other ways, you can provide a custom <code>→namer</code> for your classes:</p>
 * <pre>
 *  Ext.define('MyApp.model.Base', {
 *      extend: 'Ext.data.Model',
 *
 *      schema: {
 *          namespace: 'MyApp.model',
 *          namer: 'custom'
 *      }
 *  });
 * </pre>
 * <p>This will create a class using the alias "namer.custom". For example:</p>
 * <pre>
 *  Ext.define('MyApp.model.CustomNamer', {
 *      extend: 'Ext.data.schema.Namer',
 *
 *      alias: 'namer.custom',
 *      ...
 *  });
 * </pre>
 * <p>For details see the documentation for →<code>ext.data.schema.Namer</code>.</p>
 * @see ext.data.Model
 * @see ext.data.schema.Association
 * @see ext.data.Model#schema
 * @see #namespace
 * @see #namer
 * @see ext.data.schema.Namer
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html Original Ext JS documentation of 'Ext.data.schema.Schema'
 */
public class Schema extends Base implements IFactoryable {
  /**
   * Returns the <code>Schema</code> instance given its <code>id</code> or config object. If only the <code>id</code>
   * is specified, that <code>Schema</code> instance is looked up and returned. If there is no
   * instance already created, the <code>id</code> is assumed to be the <code>→type</code>. For example:
   * <pre>
   *  schema: 'foo'
   * </pre>
   * <p>Would be created from the alias <code>"schema.foo"</code> and assigned the <code>id</code> of "foo"
   * as well.</p>
   * @param config The id, type or config object of the schema.
   * <ul>
   * <li><code>type:String</code> (optional) —
   * The type alias of the schema. A "schema." prefix
   * is added to this string, if provided, to complete the alias. This should match
   * match the "alias" of some class derived from <code>→ext.data.schema.Schema</code>.
   * </li>
   * </ul>
   * @return The previously existing or newly created
   * instance.
   * @see #type
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#static-method-get Original Ext JS documentation of 'get'
   * @see ext.data.schema.Schema
   */
  public static native function get(config:*):Schema;

  /**
   * @param config @inheritDoc
   */
  public function Schema(config:Schema = null) {
    super();
  }

  /**
   * The number of <i>associations</i> (→<code>ext.data.schema.Association</code>)
   * in this <code>schema</code>.
   * @default 0
   * @see ext.data.schema.Association
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#property-assocCount Original Ext JS documentation of 'assocCount'
   */
  public native function get assocCount():Number;

  [ExtConfig]
  [Bindable]
  /**
   * This config is used to initialize the <code>→ext.data.Model.identifier</code> config
   * for classes that do not define one.
   * @see ext.data.Model#identifier
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#cfg-defaultIdentifier Original Ext JS documentation of 'defaultIdentifier'
   * @see #getDefaultIdentifier()
   * @see #setDefaultIdentifier()
   */
  public native function get defaultIdentifier():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultIdentifier(value:Object):void;

  /**
   * The number of <i>entities</i> (→<code>ext.data.Model</code>) in this
   * <code>schema</code>.
   * @default 0
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#property-entityCount Original Ext JS documentation of 'entityCount'
   */
  public native function get entityCount():Number;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specifies or configures the name generator for the schema.
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#cfg-namer Original Ext JS documentation of 'namer'
   * @see #getNamer()
   * @see #setNamer()
   */
  public native function get namer():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set namer(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The namespace for entity classes in this schema.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#cfg-namespace Original Ext JS documentation of 'namespace'
   * @see #getNamespace()
   * @see #setNamespace()
   */
  public native function get namespace():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set namespace(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This is a template used to produce <code>→ext.data.proxy.DataProxy</code> configurations for
   * Models that do not define an explicit <code>→ext.data.Model.proxy</code>.
   * <p>This template is processed with the Model class as the data object which means
   * any static properties of the Model are available. The most useful of these are</p>
   * <ul>
   * <li><code>prefix</code> - The <code>→urlPrefix</code> property of this instance.</li>
   * <li><code>entityName</code> - The <i>name</i> (→<code>ext.data.Model.entityName</code>) of the Model
   * (for example, "User").</li>
   * <li><code>schema</code> - This instance.</li>
   * </ul>
   * @default {
   *     type: 'ajax',
   *     url: '{prefix}/{entityName}'
   * }
   * @see ext.data.proxy.DataProxy
   * @see ext.data.Model#proxy
   * @see #urlPrefix
   * @see ext.data.Model#entityName
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#cfg-proxy Original Ext JS documentation of 'proxy'
   * @see #getProxy()
   * @see #setProxy()
   */
  public native function get proxy():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set proxy(value:*):void;

  /**
   * The name of the schema's type. This should be the suffix of the <code>alias</code> for this
   * class following the "schema." prefix. For example, if the <code>alias</code> for a schema is
   * "schema.foo" then <code>→type</code> should "foo". If an <code>alias</code> is specified on the derived
   * class, this property is set automatically.
   * @default 'default'
   * @see #type
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#property-type Original Ext JS documentation of 'type'
   */
  public native function get type():String;

  [ExtConfig]
  [Bindable]
  /**
   * This is the URL prefix used for all requests to the server. It could be something
   * like "/~api". This value is included in the <code>→proxy</code> template data as "prefix".
   * @default ""
   * @see #proxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#cfg-urlPrefix Original Ext JS documentation of 'urlPrefix'
   * @see #getUrlPrefix()
   * @see #setUrlPrefix()
   */
  public native function get urlPrefix():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set urlPrefix(value:String):void;

  /**
   * Adds an entry from a <i>matrix config</i> (→<code>ext.data.schema.ManyToMany</code>) declared by an
   * entity.
   * <p>This is the ideal method to override in a derived class if the standard, default
   * naming conventions need to be adjusted. In the override, apply whatever logic is
   * appropriate to determine the missing values and pass along the proper results to
   * this method in the <code>callParent</code>.</p>
   * @param entityType A class derived from <code>→ext.data.Model</code>.
   * @param matrixName The name of the matrix association.
   * @param relation A base name for the matrix. For information about the
   * meaning of this see →<code>ext.data.schema.Schema.ManyToMany</code>.
   * @param left The descriptor for the "left" of the matrix.
   * <ul>
   * <li><code>type:String</code> (optional) —
   * The type of the entity on the "left" of the matrix.
   * </li>
   * <li><code>field:String</code> (optional) —
   * The name of the field in the matrix table for the "left"
   * side entity. If not provided, this defaults to the <code>left.type</code> name
   * <i>singularized</i> (→<code>ext.util.Inflector.singularize()</code>) and uncapitalized followed by
   * "Id". For example, "userId" for a <code>left.type</code> of "Users".
   * </li>
   * <li><code>role:String</code> (optional) —
   * The name of the relationship from the <code>left.type</code> to the
   * <code>right.type</code>. If not provided, this defaults to the <code>left.type</code> name
   * <i>pluralized</i> (→<code>ext.util.Inflector.pluralize()</code>) and uncapitalized. For example,
   * "users" for a <code>left.type</code> of "User".
   * </li>
   * </ul>
   * @param right The descriptor for the "right" of the matrix.
   * <ul>
   * <li><code>type:String</code> (optional) —
   * The type of the entity on the "right" of the matrix.
   * </li>
   * <li><code>field:String</code> (optional) —
   * The name of the field in the matrix table for the
   * "right" side entity. If not provided, this defaults in the same way as <code>left.field</code>
   * except this is based on <code>right.type</code>.
   * </li>
   * <li><code>role:String</code> (optional) —
   * The name of the relationship from the <code>right.type</code> to
   * the <code>left.type</code>. If not provided, this defaults in the same way as <code>left.role</code>
   * except this is based on <code>right.type</code>.
   * </li>
   * </ul>
   * @see ext.data.schema.ManyToMany
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#method-addMatrix Original Ext JS documentation of 'addMatrix'
   * @see ext.data.Model
   * @see ext.data.schema.Schema#ManyToMany
   * @see ext.util.SInflector#singularize() ext.util.Inflector.singularize()
   * @see ext.util.SInflector#pluralize() ext.util.Inflector.pluralize()
   */
  protected native function addMatrix(entityType:ExtClass, matrixName:String, relation:String = null, left:Object = null, right:Object = null):void;

  /**
   * Adds a →<code>ext.data.field.DataField.reference</code> field association for an entity
   * to this <code>schema</code>.
   * <p>This is the ideal method to override in a derived class if the standard, default
   * naming conventions need to be adjusted. In the override, apply whatever logic is
   * appropriate to determine the missing values and pass along the proper results to
   * this method in the <code>callParent</code>.</p>
   * @param entityType A class derived from <code>→ext.data.Model</code>.
   * @param referenceField The <code>field</code> with the <code>reference</code> config.
   * @param descr The <code>reference</code> descriptor from the <code>referenceField</code> if one
   * was given in the field definition.
   * <ul>
   * <li><code>association:String</code> (optional) —
   * The name of the association. If empty or null, this
   * will be derived from <code>entityType</code>, <code>role</code>, <code>inverse</code> and
   * <code>referenceField.unique</code>.
   * </li>
   * <li><code>role:String</code> (optional) —
   * The name of the relationship from <code>entityType</code> to the target
   * <code>→type</code>. If not specified, the default is the <code>referenceField.name</code> (minus any "Id"
   * suffix if present).
   * </li>
   * <li><code>inverse:String</code> (optional) —
   * The name of the relationship from the target <code>→type</code>
   * to the <code>entityType</code>. If not specified, this is derived from the
   * →<code>ext.data.Model.entityName</code> of the <code>entityType</code>
   * (<i>singularized</i> (→<code>ext.util.Inflector.singularize()</code>) or
   * <i>pluralized</i> (→<code>ext.util.Inflector.pluralize()</code>) based on <code>referenceField.unique</code>).
   * </li>
   * <li><code>type:String</code> (optional) —
   * The →<code>ext.data.Model.entityName</code> of the
   * target of the reference.
   * </li>
   * </ul>
   * @param unique Indicates if the reference is one-to-one.
   * @default false
   * @see ext.data.field.DataField#reference
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#method-addReference Original Ext JS documentation of 'addReference'
   * @see ext.data.Model
   * @see #type
   * @see ext.data.Model#entityName
   * @see ext.util.SInflector#singularize() ext.util.Inflector.singularize()
   * @see ext.util.SInflector#pluralize() ext.util.Inflector.pluralize()
   */
  protected native function addReference(entityType:ExtClass, referenceField:DataField, descr:Object = null, unique:Boolean = false):void;

  /**
   * Returns an <code>Association</code> by name.
   * @param name The name of the association.
   * @return The association instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#method-getAssociation Original Ext JS documentation of 'getAssociation'
   */
  public native function getAssociation(name:String):Association;

  /**
   * Returns the value of <code>defaultIdentifier</code>.
   * @see #defaultIdentifier
   */
  public native function getDefaultIdentifier():Object;

  /**
   * Returns an entity by name.
   * @param name The name of the entity
   * @return The entity class.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#method-getEntity Original Ext JS documentation of 'getEntity'
   */
  public native function getEntity(name:String):Model;

  /**
   * Get the entity name taking into account the →<code>namespace</code>.
   * @param cls The model class or name of the class.
   * @return The entity name
   * @see #namespace
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#method-getEntityName Original Ext JS documentation of 'getEntityName'
   */
  public native function getEntityName(cls:*):String;

  /**
   * Returns the value of <code>namer</code>.
   * @see #namer
   */
  public native function getNamer():*;

  /**
   * Returns the value of <code>namespace</code>.
   * @see #namespace
   */
  public native function getNamespace():String;

  /**
   * Returns the value of <code>proxy</code>.
   * @see #proxy
   */
  public native function getProxy():*;

  /**
   * Returns the value of <code>urlPrefix</code>.
   * @see #urlPrefix
   */
  public native function getUrlPrefix():String;

  /**
   * Checks if the passed entity has attached associations that need to be read when
   * using nested loading.
   * @param name The name, instance, or Model class.
   * @return <code>true</code> if there are associations attached to the entity.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#method-hasAssociations Original Ext JS documentation of 'hasAssociations'
   */
  public native function hasAssociations(name:*):Boolean;

  /**
   * Checks if an entity is defined
   * @param entity The name or model
   * @return True if this entity is defined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.schema.Schema.html#method-hasEntity Original Ext JS documentation of 'hasEntity'
   */
  public native function hasEntity(entity:*):Boolean;

  /**
   * Sets the value of <code>defaultIdentifier</code>.
   * @param defaultIdentifier The new value.
   * @see #defaultIdentifier
   */
  public native function setDefaultIdentifier(defaultIdentifier:Object):void;

  /**
   * Sets the value of <code>namer</code>.
   * @param namer The new value.
   * @see #namer
   */
  public native function setNamer(namer:*):void;

  /**
   * Sets the value of <code>namespace</code>.
   * @param namespace The new value.
   * @see #namespace
   */
  public native function setNamespace(namespace:String):void;

  /**
   * Sets the value of <code>proxy</code>.
   * @param proxy The new value.
   * @see #proxy
   */
  public native function setProxy(proxy:*):void;

  /**
   * Sets the value of <code>urlPrefix</code>.
   * @param urlPrefix The new value.
   * @see #urlPrefix
   */
  public native function setUrlPrefix(urlPrefix:String):void;
}
}