package ext.data.summary {
import ext.Base;
import ext.data.Model;
import ext.mixin.IFactoryable;

[Native("Ext.data.summary.Base", require)]
/**
 * The base class for calculating data summaries. The summary is calculated using the
 * →<code>calculate()</code> method. This is overridden in subclasses.
 * @see #calculate()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.summary.Base.html Original Ext JS documentation of 'Ext.data.summary.Base'
 */
public class SummaryBase extends Base implements IFactoryable {
  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * This method calculates the summary value of the given records.
   * @param records The records to aggregate.
   * @param property The property to aggregate on.
   * @param root The root to extra the data from.
   * @param begin The starting index to calculate from.
   * @param end The index at which to stop calculating. The item at this
   * index will <i>not</i> be included in the calculation.
   * @return The calculated summary value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.summary.Base.html#method-calculate Original Ext JS documentation of 'calculate'
   */
  public native function calculate(records:*, property:String, root:String, begin:Number, end:Number):Object;

  /**
   * Extract the underlying value from the data object.
   * @param record The record.
   * @param property The property to extract.
   * @param root The root on the data object.
   * @return The value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.summary.Base.html#method-extractValue Original Ext JS documentation of 'extractValue'
   */
  protected native function extractValue(record:Model, property:String, root:String):Object;
}
}