package ext.data.summary {

[Native("Ext.data.summary.None", require)]
/**
 * Produces no value for a summary. This would be used for fields like <code>id</code> or other
 * value that does not aggregate.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.summary.None.html Original Ext JS documentation of 'Ext.data.summary.None'
 */
public class SummaryNone extends SummaryBase {
  [ExtConfig]
  [Bindable]
  /**
   * The value to report for the summary.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.summary.None.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set value(value:*):void;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  public native function getValue():*;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  public native function setValue(value:*):void;
}
}